/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.WebdavException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystemStore
implements WebdavStore {
    private static Logger log = LoggerFactory.getLogger(LocalFileSystemStore.class);
    private static int BUF_SIZE = 50000;
    private File root = null;

    public LocalFileSystemStore(File root) {
        this.root = root;
    }

    public void begin(Principal principal) throws WebdavException {
        log.trace("LocalFileSystemStore.begin()");
        if (!this.root.exists() && !this.root.mkdirs()) {
            throw new WebdavException("root path: " + this.root.getAbsolutePath() + " does not exist and could not be created");
        }
    }

    public void checkAuthentication() throws SecurityException {
        log.trace("LocalFileSystemStore.checkAuthentication()");
    }

    public void commit() throws WebdavException {
        log.trace("LocalFileSystemStore.commit()");
    }

    public void rollback() throws WebdavException {
        log.trace("LocalFileSystemStore.rollback()");
    }

    public boolean objectExists(String uri) throws WebdavException {
        File file = new File(this.root, uri);
        log.trace("LocalFileSystemStore.objectExists(" + uri + ")=" + file.exists());
        return file.exists();
    }

    public boolean isFolder(String uri) throws WebdavException {
        File file = new File(this.root, uri);
        log.trace("LocalFileSystemStore.isFolder(" + uri + ")=" + file.isDirectory());
        return file.isDirectory();
    }

    public boolean isResource(String uri) throws WebdavException {
        File file = new File(this.root, uri);
        log.trace("LocalFileSystemStore.isResource(" + uri + ") " + file.isFile());
        return file.isFile();
    }

    public void createFolder(String uri) throws WebdavException {
        log.trace("LocalFileSystemStore.createFolder(" + uri + ")");
        File file = new File(this.root, uri);
        if (!file.mkdir()) {
            throw new WebdavException("cannot create folder: " + uri);
        }
    }

    public void createResource(String uri) throws WebdavException {
        log.trace("LocalFileSystemStore.createResource(" + uri + ")");
        File file = new File(this.root, uri);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + uri);
            }
        }
        catch (IOException e) {
            log.error("LocalFileSystemStore.createResource(" + uri + ") failed");
            throw new WebdavException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceContent(String uri, InputStream is, String contentType, String characterEncoding) throws WebdavException {
        log.trace("LocalFileSystemStore.setResourceContent(" + uri + ")");
        File file = new File(this.root, uri);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                int read;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    ((OutputStream)os).write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    is.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            log.error("LocalFileSystemStore.setResourceContent(" + uri + ") failed");
            throw new WebdavException((Throwable)e);
        }
    }

    public Date getLastModified(String uri) throws WebdavException {
        log.trace("LocalFileSystemStore.getLastModified(" + uri + ")");
        File file = new File(this.root, uri);
        return new Date(file.lastModified());
    }

    public Date getCreationDate(String uri) throws WebdavException {
        log.trace("LocalFileSystemStore.getCreationDate(" + uri + ")");
        File file = new File(this.root, uri);
        return new Date(file.lastModified());
    }

    public String[] getChildrenNames(String uri) throws WebdavException {
        log.trace("LocalFileSystemStore.getChildrenNames(" + uri + ")");
        File file = new File(this.root, uri);
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            for (int i = 0; i < children.length; ++i) {
                String name = children[i].getName();
                childList.add(name);
            }
            String[] childrenNames = new String[childList.size()];
            childrenNames = childList.toArray(childrenNames);
            return childrenNames;
        }
        return null;
    }

    public InputStream getResourceContent(String uri) throws WebdavException {
        BufferedInputStream in;
        log.trace("LocalFileSystemStore.getResourceContent(" + uri + ")");
        File file = new File(this.root, uri);
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            log.error("LocalFileSystemStore.getResourceContent(" + uri + ") failed");
            throw new WebdavException((Throwable)e);
        }
        return in;
    }

    public long getResourceLength(String uri) throws WebdavException {
        log.trace("LocalFileSystemStore.getResourceLength(" + uri + ")");
        File file = new File(this.root, uri);
        return file.length();
    }

    public void removeObject(String uri) throws WebdavException {
        File file = new File(this.root, uri);
        boolean success = file.delete();
        log.trace("LocalFileSystemStore.removeObject(" + uri + ")=" + success);
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }
    }
}

