/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav;

import java.util.Hashtable;
import net.sf.webdav.ResourceLocks;

public class ResourceLocks {
    private final int fCleanupLimit = 100000;
    private int fCleanupCounter = 0;
    private Hashtable fLocks = new Hashtable();
    private LockObject fRoot = new LockObject(this, "/");

    public synchronized boolean lock(String path, String owner, boolean exclusive, int depth) {
        LockObject lo = this.generateLockObjects(path);
        if (lo.checkLocks(exclusive, depth)) {
            if (lo.addLockObjectOwner(owner)) {
                lo.fExclusive = exclusive;
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized void unlock(String path, String owner) {
        if (this.fLocks.containsKey(path)) {
            LockObject lo = (LockObject)this.fLocks.get(path);
            lo.removeLockObjectOwner(owner);
        } else {
            System.out.println("net.sf.webdav.ResourceLocks.unlock(): no lock for path " + path);
        }
        if (this.fCleanupCounter > 100000) {
            this.fCleanupCounter = 0;
            this.cleanLockObjects(this.fRoot);
        }
    }

    private LockObject generateLockObjects(String path) {
        if (!this.fLocks.containsKey(path)) {
            LockObject returnObject = new LockObject(this, path);
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                LockObject parentLockObject = this.generateLockObjects(parentPath);
                parentLockObject.addChild(returnObject);
                returnObject.fParent = parentLockObject;
            }
            return returnObject;
        }
        return (LockObject)this.fLocks.get(path);
    }

    private boolean cleanLockObjects(LockObject lo) {
        if (lo.fChildren == null) {
            if (lo.fOwner == null) {
                lo.removeLockObject();
                return true;
            }
            return false;
        }
        boolean canDelete = true;
        int limit = lo.fChildren.length;
        for (int i = 0; i < limit; ++i) {
            if (!this.cleanLockObjects(lo.fChildren[i])) {
                canDelete = false;
                continue;
            }
            --i;
            --limit;
        }
        if (canDelete) {
            if (lo.fOwner == null) {
                lo.removeLockObject();
                return true;
            }
            return false;
        }
        return false;
    }

    private String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return null;
        }
        if (slash == 0) {
            return "/";
        }
        return path.substring(0, slash);
    }

    static /* synthetic */ Hashtable access$000(ResourceLocks x0) {
        return x0.fLocks;
    }

    static /* synthetic */ int access$108(ResourceLocks x0) {
        return x0.fCleanupCounter++;
    }

    static /* synthetic */ LockObject access$200(ResourceLocks x0) {
        return x0.fRoot;
    }
}

