/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.ObjectNotFoundException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.fromcatalina.RequestUtil;
import net.sf.webdav.methods.DoDelete;
import net.sf.webdav.methods.ReportingMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoCopy
extends ReportingMethod {
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");
    private WebdavStore store;
    private ResourceLocks resourceLocks;
    private DoDelete doDelete;
    private boolean readOnly;

    public DoCopy(WebdavStore store, ResourceLocks resourceLocks, DoDelete doDelete, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.doDelete = doDelete;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.trace("-- " + this.getClass().getName());
        String path = this.getRelativePath(req);
        if (!this.readOnly) {
            String lockOwner = "doCopy" + System.currentTimeMillis() + req.toString();
            if (this.resourceLocks.lock(path, lockOwner, false, -1)) {
                try {
                    this.copyResource(req, resp);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(409, req.getRequestURI());
                }
                catch (ObjectNotFoundException e) {
                    resp.sendError(404, req.getRequestURI());
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.resourceLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean copyResource(HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException {
        String lockOwner;
        String path;
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return false;
        }
        int protocolIndex = (destinationPath = RequestUtil.URLDecode((String)destinationPath, (String)"UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = this.normalize(destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        if ((path = this.getRelativePath(req)).equals(destinationPath)) {
            resp.sendError(403);
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        if (this.resourceLocks.lock(destinationPath, lockOwner = "copyResource" + System.currentTimeMillis() + req.toString(), true, -1)) {
            try {
                if (!this.store.objectExists(path)) {
                    resp.sendError(500);
                    boolean bl = false;
                    return bl;
                }
                boolean exists = this.store.objectExists(destinationPath);
                Hashtable errorList = new Hashtable();
                if (overwrite) {
                    if (exists) {
                        this.doDelete.deleteResource(destinationPath, errorList, req, resp);
                    } else {
                        resp.setStatus(201);
                    }
                } else {
                    if (exists) {
                        resp.sendError(412);
                        boolean bl = false;
                        return bl;
                    }
                    resp.setStatus(201);
                }
                this.copy(path, destinationPath, errorList, req, resp);
                if (errorList.isEmpty()) return true;
                this.sendReport(req, resp, errorList);
                return true;
            }
            finally {
                this.resourceLocks.unlock(destinationPath, lockOwner);
            }
        } else {
            resp.sendError(500);
            return false;
        }
    }

    private void copy(String sourcePath, String destinationPath, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException {
        if (this.store.isResource(sourcePath)) {
            this.store.createResource(destinationPath);
            this.store.setResourceContent(destinationPath, this.store.getResourceContent(sourcePath), null, null);
        } else if (this.store.isFolder(sourcePath)) {
            this.copyFolder(sourcePath, destinationPath, errorList, req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void copyFolder(String sourcePath, String destinationPath, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        this.store.createFolder(destinationPath);
        boolean infiniteDepth = true;
        if (req.getHeader("depth") != null && req.getHeader("depth").equals("0")) {
            infiniteDepth = false;
        }
        if (infiniteDepth) {
            String[] children = this.store.getChildrenNames(sourcePath);
            for (int i = children.length - 1; i >= 0; --i) {
                children[i] = "/" + children[i];
                try {
                    if (this.store.isResource(sourcePath + children[i])) {
                        this.store.createResource(destinationPath + children[i]);
                        this.store.setResourceContent(destinationPath + children[i], this.store.getResourceContent(sourcePath + children[i]), null, null);
                        continue;
                    }
                    this.copyFolder(sourcePath + children[i], destinationPath + children[i], errorList, req, resp);
                    continue;
                }
                catch (AccessDeniedException e) {
                    errorList.put(destinationPath + children[i], new Integer(403));
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    errorList.put(destinationPath + children[i], new Integer(404));
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    errorList.put(destinationPath + children[i], new Integer(409));
                    continue;
                }
                catch (WebdavException e) {
                    errorList.put(destinationPath + children[i], new Integer(500));
                }
            }
        }
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }
}

