/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.ObjectNotFoundException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.methods.ReportingMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoDelete
extends ReportingMethod {
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");
    private WebdavStore store;
    private ResourceLocks resourceLocks;
    private boolean readOnly;

    public DoDelete(WebdavStore store, ResourceLocks resourceLocks, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.trace("-- " + this.getClass().getName());
        if (!this.readOnly) {
            String lockOwner;
            String path = this.getRelativePath(req);
            if (this.resourceLocks.lock(path, lockOwner = "doDelete" + System.currentTimeMillis() + req.toString(), true, -1)) {
                try {
                    Hashtable errorList = new Hashtable();
                    this.deleteResource(path, errorList, req, resp);
                    if (errorList.isEmpty()) return;
                    this.sendReport(req, resp, errorList);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.resourceLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    public void deleteResource(String path, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws IOException, WebdavException {
        resp.setStatus(204);
        if (!this.readOnly) {
            if (this.store.isResource(path)) {
                this.store.removeObject(path);
            } else if (this.store.isFolder(path)) {
                this.deleteFolder(path, errorList, req, resp);
                this.store.removeObject(path);
            } else {
                resp.sendError(404);
            }
        } else {
            resp.sendError(403);
        }
    }

    private void deleteFolder(String path, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        String[] children = this.store.getChildrenNames(path);
        for (int i = children.length - 1; i >= 0; --i) {
            children[i] = "/" + children[i];
            try {
                if (this.store.isResource(path + children[i])) {
                    this.store.removeObject(path + children[i]);
                    continue;
                }
                this.deleteFolder(path + children[i], errorList, req, resp);
                this.store.removeObject(path + children[i]);
                continue;
            }
            catch (AccessDeniedException e) {
                errorList.put(path + children[i], new Integer(403));
                continue;
            }
            catch (ObjectNotFoundException e) {
                errorList.put(path + children[i], new Integer(404));
                continue;
            }
            catch (WebdavException e) {
                errorList.put(path + children[i], new Integer(500));
            }
        }
    }
}

