/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.methods.DeterminableMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoMkcol
extends DeterminableMethod {
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");
    private WebdavStore store;
    private ResourceLocks resourceLocks;
    private boolean readOnly;

    public DoMkcol(WebdavStore store, ResourceLocks resourceLocks, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.trace("-- " + this.getClass().getName());
        if (!this.readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(path);
            String lockOwner = "doMkcol" + System.currentTimeMillis() + req.toString();
            if (this.resourceLocks.lock(path, lockOwner, true, 0)) {
                try {
                    if (parentPath != null && this.store.isFolder(parentPath)) {
                        boolean isFolder = this.store.isFolder(path);
                        if (!this.store.objectExists(path)) {
                            try {
                                this.store.createFolder(path);
                                resp.setStatus(201);
                            }
                            catch (ObjectAlreadyExistsException e) {
                                String methodsAllowed = this.determineMethodsAllowed(true, isFolder);
                                resp.addHeader("Allow", methodsAllowed);
                                resp.sendError(405);
                            }
                        }
                        String methodsAllowed = this.determineMethodsAllowed(true, isFolder);
                        resp.addHeader("Allow", methodsAllowed);
                        resp.sendError(405);
                    }
                    resp.sendError(409);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.resourceLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(403);
        }
    }
}

