/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.methods.DoCopy;
import net.sf.webdav.methods.DoDelete;
import net.sf.webdav.methods.ReportingMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoMove
extends ReportingMethod {
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");
    private ResourceLocks resourceLocks;
    private DoDelete doDelete;
    private DoCopy doCopy;
    private boolean readOnly;

    public DoMove(ResourceLocks resourceLocks, DoDelete doDelete, DoCopy doCopy, boolean readOnly) {
        this.resourceLocks = resourceLocks;
        this.doDelete = doDelete;
        this.doCopy = doCopy;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.readOnly) {
            log.trace("-- " + this.getClass().getName());
            String path = this.getRelativePath(req);
            String lockOwner = "doMove" + System.currentTimeMillis() + req.toString();
            if (this.resourceLocks.lock(path, lockOwner, false, -1)) {
                try {
                    if (this.doCopy.copyResource(req, resp)) {
                        Hashtable errorList = new Hashtable();
                        this.doDelete.deleteResource(path, errorList, req, resp);
                        if (errorList.isEmpty()) return;
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    resp.sendError(500);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.resourceLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }
}

