/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ResourceLocks;
import net.sf.webdav.WebdavStore;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.methods.DeterminableMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoOptions
extends DeterminableMethod {
    private static Logger log = LoggerFactory.getLogger((String)"net.sf.webdav.methods");
    private WebdavStore store;
    private ResourceLocks resLocks;

    public DoOptions(WebdavStore store, ResourceLocks resLocks) {
        this.store = store;
        this.resLocks = resLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.trace("-- " + this.getClass().getName());
        String lockOwner = "doOptions" + System.currentTimeMillis() + req.toString();
        String path = this.getRelativePath(req);
        if (this.resLocks.lock(path, lockOwner, false, 0)) {
            try {
                resp.addHeader("DAV", "1, 2");
                String methodsAllowed = this.determineMethodsAllowed(this.store.objectExists(path), this.store.isFolder(path));
                resp.addHeader("Allow", methodsAllowed);
                resp.addHeader("MS-Author-Via", "DAV");
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                resp.sendError(500);
            }
            finally {
                this.resLocks.unlock(path, lockOwner);
            }
        } else {
            resp.sendError(500);
        }
    }
}

