/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.categorynav;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

public class CategoryExplorerWidget
extends Composite
implements TreeListener {
    private Tree navTreeWidget = new Tree();
    private VerticalPanel panel = new VerticalPanel();
    private RepositoryServiceAsync service = RepositoryServiceFactory.getService();
    private CategorySelectHandler categorySelectHandler;
    private String selectedPath;
    private Panel emptyCategories;
    private static Constants constants = (Constants)GWT.create(Constants.class);

    public void setTreeSize(String width) {
        this.navTreeWidget.setWidth(width);
    }

    public CategoryExplorerWidget(CategorySelectHandler handler) {
        this.panel.add((Widget)this.navTreeWidget);
        this.categorySelectHandler = handler;
        this.loadInitialTree();
        this.initWidget((Widget)this.panel);
        this.navTreeWidget.addTreeListener((TreeListener)this);
        this.setStyleName("category-explorer-Tree");
    }

    public void refresh() {
        this.navTreeWidget.removeItems();
        this.selectedPath = null;
        this.loadInitialTree();
    }

    public void showEmptyTree() {
        if (this.emptyCategories == null) {
            AbsolutePanel p = new AbsolutePanel();
            p.add((Widget)new HTML(constants.NoCategoriesCreatedYetTip()));
            Button b = new Button(constants.Refresh());
            b.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            p.add((Widget)b);
            p.setStyleName("small-Text");
            this.emptyCategories = p;
            this.panel.add((Widget)this.emptyCategories);
        }
        this.emptyCategories.setVisible(true);
    }

    private void loadInitialTree() {
        this.navTreeWidget.addItem(constants.PleaseWait());
        DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String h(String cat) {
        return cat.replace("<", "&lt;").replace(">", "&gt;");
    }

    private void hideEmptyTree() {
        if (this.emptyCategories != null) {
            this.emptyCategories.setVisible(false);
        }
    }

    public void onTreeItemSelected(TreeItem item) {
        this.selectedPath = this.getPath(item);
        this.categorySelectHandler.selected(this.selectedPath);
    }

    public void onTreeItemStateChanged(TreeItem item) {
        if (this.hasBeenLoaded(item)) {
            return;
        }
        TreeItem root = item;
        this.selectedPath = this.getPath(item);
        this.service.loadChildCategories(this.selectedPath, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean hasBeenLoaded(TreeItem item) {
        return item.getChildCount() != 1 || !(item.getChild(0) instanceof PendingItem);
    }

    private String getPath(TreeItem item) {
        String categoryPath = (String)item.getUserObject();
        if (categoryPath == null) {
            return null;
        }
        TreeItem parent = item.getParentItem();
        while (parent.getUserObject() != null) {
            categoryPath = (String)parent.getUserObject() + "/" + categoryPath;
            parent = parent.getParentItem();
        }
        return categoryPath;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean isSelected() {
        return this.selectedPath != null;
    }

    static /* synthetic */ String access$002(CategoryExplorerWidget x0, String x1) {
        x0.selectedPath = x1;
        return x0.selectedPath;
    }

    static /* synthetic */ Tree access$100(CategoryExplorerWidget x0) {
        return x0.navTreeWidget;
    }

    static /* synthetic */ void access$200(CategoryExplorerWidget x0) {
        x0.hideEmptyTree();
    }

    static /* synthetic */ String access$300(CategoryExplorerWidget x0, String x1) {
        return x0.h(x1);
    }

    static /* synthetic */ RepositoryServiceAsync access$400(CategoryExplorerWidget x0) {
        return x0.service;
    }

    static /* synthetic */ Constants access$500() {
        return constants;
    }
}

