/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.dt.ConditionCol;
import org.drools.guvnor.client.modeldriven.dt.DTColumnConfig;
import org.drools.guvnor.client.modeldriven.dt.GuidedDecisionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GuidedDTColumnConfig
extends FormStylePopup {
    private GuidedDecisionTable dt;
    private SuggestionCompletionEngine sce;
    private ConditionCol editingCol;
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private SmallLabel operatorLabel = new SmallLabel();
    private Constants constants = (Constants)GWT.create(Constants.class);

    public GuidedDTColumnConfig(SuggestionCompletionEngine sce, GuidedDecisionTable dt, Command refreshGrid, ConditionCol col, boolean isNew) {
        this.setModal(false);
        this.dt = dt;
        this.sce = sce;
        this.editingCol = new ConditionCol();
        this.editingCol.boundName = col.boundName;
        this.editingCol.constraintValueType = col.constraintValueType;
        this.editingCol.factField = col.factField;
        this.editingCol.factType = col.factType;
        this.editingCol.header = col.header;
        this.editingCol.operator = col.operator;
        this.editingCol.valueList = col.valueList;
        this.editingCol.defaultValue = col.defaultValue;
        this.editingCol.hideColumn = col.hideColumn;
        this.setTitle(this.constants.ConditionColumnConfiguration());
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton("images/edit.gif", this.constants.ChooseAnExistingPatternThatThisColumnAddsTo(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pattern.add((Widget)changePattern);
        this.addAttribute(this.constants.Pattern(), (Widget)pattern);
        RadioButton literal = new RadioButton("constraintValueType", this.constants.LiteralValue());
        RadioButton formula = new RadioButton("constraintValueType", this.constants.Formula());
        RadioButton predicate = new RadioButton("constraintValueType", this.constants.Predicate());
        HorizontalPanel valueTypes = new HorizontalPanel();
        valueTypes.add((Widget)literal);
        valueTypes.add((Widget)formula);
        valueTypes.add((Widget)predicate);
        this.addAttribute(this.constants.CalculationType(), (Widget)valueTypes);
        switch (this.editingCol.constraintValueType) {
            case 1: {
                literal.setChecked(true);
                break;
            }
            case 3: {
                formula.setChecked(true);
                break;
            }
            case 5: {
                predicate.setChecked(true);
            }
        }
        literal.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        formula.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        predicate.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel field = new HorizontalPanel();
        field.add((Widget)this.fieldLabel);
        ImageButton editField = new ImageButton("images/edit.gif", this.constants.EditTheFieldThatThisColumnOperatesOn(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        field.add((Widget)editField);
        this.addAttribute(this.constants.Field(), (Widget)field);
        this.doFieldLabel();
        HorizontalPanel operator = new HorizontalPanel();
        operator.add((Widget)this.operatorLabel);
        ImageButton editOp = new ImageButton("images/edit.gif", this.constants.EditTheOperatorThatIsUsedToCompareDataWithThisField(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        operator.add((Widget)editOp);
        this.addAttribute(this.constants.Operator(), (Widget)operator);
        this.doOperatorLabel();
        TextBox valueList = new TextBox();
        valueList.setText(this.editingCol.valueList);
        valueList.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel vl = new HorizontalPanel();
        vl.add((Widget)valueList);
        vl.add((Widget)new InfoPopup(this.constants.ValueList(), this.constants.ValueListsExplanation()));
        this.addAttribute(this.constants.optionalValueList(), (Widget)vl);
        TextBox header = new TextBox();
        header.setText(col.header);
        header.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute(this.constants.ColumnHeaderDescription(), (Widget)header);
        this.addAttribute(this.constants.DefaultValue(), (Widget)GuidedDTColumnConfig.getDefaultEditor((DTColumnConfig)this.editingCol));
        Button apply = new Button(this.constants.ApplyChanges());
        apply.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute("", (Widget)apply);
    }

    public static HorizontalPanel getDefaultEditor(DTColumnConfig editingCol) {
        TextBox defaultValue = new TextBox();
        defaultValue.setText(editingCol.defaultValue);
        CheckBox hide = new CheckBox(((Constants)GWT.create(Constants.class)).HideThisColumn());
        hide.setChecked(editingCol.hideColumn);
        hide.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        defaultValue.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)defaultValue);
        hp.add((Widget)hide);
        return hp;
    }

    private boolean unique(String header) {
        for (ConditionCol o : this.dt.conditionCols) {
            if (!o.header.equals(header)) continue;
            return false;
        }
        return true;
    }

    private TextBox getFieldLabel() {
        TextBox box = new TextBox();
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private void applyConsTypeChange(int newType) {
        this.editingCol.constraintValueType = newType;
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    private void doOperatorLabel() {
        if (this.editingCol.constraintValueType == 5) {
            this.operatorLabel.setText(this.constants.notNeededForPredicate());
        } else if (this.nil(this.editingCol.factType)) {
            this.operatorLabel.setText(this.constants.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.factField)) {
            this.operatorLabel.setText(this.constants.pleaseChooseAFieldFirst());
        } else if (this.nil(this.editingCol.operator)) {
            this.operatorLabel.setText(this.constants.pleaseSelectAField());
        } else {
            this.operatorLabel.setText(HumanReadable.getOperatorDisplayName((String)this.editingCol.operator));
        }
    }

    private void showOperatorChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(this.constants.SetTheOperator());
        pop.setModal(false);
        String[] ops = this.sce.getOperatorCompletions(this.editingCol.factType, this.editingCol.factField);
        ListBox box = new ListBox();
        for (int i = 0; i < ops.length; ++i) {
            box.addItem(HumanReadable.getOperatorDisplayName((String)ops[i]), ops[i]);
        }
        box.addItem(this.constants.noOperator(), "");
        pop.addAttribute(this.constants.Operator(), (Widget)box);
        Button b = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doFieldLabel() {
        if (this.editingCol.constraintValueType == 5) {
            this.fieldLabel.setText(this.constants.notNeededForPredicate());
        } else if (this.nil(this.editingCol.factType)) {
            this.fieldLabel.setText(this.constants.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.factField)) {
            this.fieldLabel.setText(this.constants.pleaseSelectAField());
        } else {
            this.fieldLabel.setText(this.editingCol.factField);
        }
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    protected void showFieldChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        String[] fields = this.sce.getFieldCompletions(this.editingCol.factType);
        ListBox box = new ListBox();
        for (int i = 0; i < fields.length; ++i) {
            box.addItem(fields[i]);
        }
        pop.addAttribute(this.constants.Field(), (Widget)box);
        Button b = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doPatternLabel() {
        if (this.editingCol.factType != null) {
            this.patternLabel.setText(this.editingCol.factType + " [" + this.editingCol.boundName + "]");
        }
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    protected void showChangePattern(Widget w) {
        ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        FormStylePopup pop = new FormStylePopup();
        Button ok = new Button(this.constants.OK());
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)pats);
        hp.add((Widget)ok);
        pop.addAttribute(this.constants.ChooseExistingPatternToAddColumnTo(), (Widget)hp);
        pop.addAttribute("", (Widget)new HTML(this.constants.ORwithEmphasis()));
        Button createPattern = new Button(this.constants.CreateNewFactPattern());
        createPattern.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)createPattern);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showNewPatternDialog() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(this.constants.CreateANewFactPattern());
        ListBox types = new ListBox();
        for (int i = 0; i < this.sce.factTypes.length; ++i) {
            types.addItem(this.sce.factTypes[i]);
        }
        pop.addAttribute(this.constants.FactType(), (Widget)types);
        TextBox binding = new TextBox();
        binding.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(this.constants.name(), (Widget)binding);
        Button ok = new Button(this.constants.OK());
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private boolean checkUnique(String fn, List<ConditionCol> conditionCols) {
        for (ConditionCol c : conditionCols) {
            if (!c.boundName.equals(fn)) continue;
            return false;
        }
        return true;
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (int i = 0; i < this.dt.conditionCols.size(); ++i) {
            ConditionCol c = (ConditionCol)this.dt.conditionCols.get(i);
            if (vars.contains(c.boundName)) continue;
            patterns.addItem(c.factType + " [" + c.boundName + "]", c.factType + " " + c.boundName);
            vars.add(c.boundName);
        }
        return patterns;
    }

    static /* synthetic */ void access$000(GuidedDTColumnConfig x0, int x1) {
        x0.applyConsTypeChange(x1);
    }

    static /* synthetic */ void access$100(GuidedDTColumnConfig x0) {
        x0.showOperatorChange();
    }

    static /* synthetic */ ConditionCol access$200(GuidedDTColumnConfig x0) {
        return x0.editingCol;
    }

    static /* synthetic */ Constants access$300(GuidedDTColumnConfig x0) {
        return x0.constants;
    }

    static /* synthetic */ boolean access$400(GuidedDTColumnConfig x0, String x1) {
        return x0.unique(x1);
    }

    static /* synthetic */ void access$500(GuidedDTColumnConfig x0) {
        x0.doOperatorLabel();
    }

    static /* synthetic */ void access$600(GuidedDTColumnConfig x0) {
        x0.doFieldLabel();
    }

    static /* synthetic */ void access$700(GuidedDTColumnConfig x0) {
        x0.doPatternLabel();
    }

    static /* synthetic */ GuidedDecisionTable access$800(GuidedDTColumnConfig x0) {
        return x0.dt;
    }

    static /* synthetic */ boolean access$900(GuidedDTColumnConfig x0, String x1, List x2) {
        return x0.checkUnique(x1, x2);
    }
}

