/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.DropDownData;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.ActionFieldValue;
import org.drools.guvnor.client.modeldriven.brl.ActionInsertFact;
import org.drools.guvnor.client.modeldriven.brl.ActionSetField;
import org.drools.guvnor.client.modeldriven.brl.ActionUpdateField;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.ui.ActionSetFieldWidget;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;

public class ActionSetFieldWidget
extends DirtyableComposite {
    private final ActionSetField model;
    private final SuggestionCompletionEngine completions;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private String[] fieldCompletions;
    private final RuleModeller modeller;
    private String variableClass;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public ActionSetFieldWidget(RuleModeller mod, ActionSetField set, SuggestionCompletionEngine com) {
        this.model = set;
        this.completions = com;
        this.layout = new DirtyableFlexTable();
        this.modeller = mod;
        this.layout.setStyleName("model-builderInner-Background");
        if (this.completions.isGlobalVariable(set.variable)) {
            this.fieldCompletions = this.completions.getFieldCompletionsForGlobalVariable(set.variable);
            this.variableClass = (String)this.completions.globalTypes.get(set.variable);
        } else {
            FactPattern pattern = mod.getModel().getBoundFact(set.variable);
            if (pattern != null) {
                this.fieldCompletions = this.completions.getFieldCompletions(pattern.factType);
                this.variableClass = pattern.factType;
                this.isBoundFact = true;
            } else {
                ActionInsertFact patternRhs = mod.getModel().getRhsBoundFact(set.variable);
                if (patternRhs != null) {
                    this.fieldCompletions = this.completions.getFieldCompletions(patternRhs.factType);
                    this.variableClass = patternRhs.factType;
                    this.isBoundFact = true;
                }
            }
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getSetterLabel());
        DirtyableFlexTable inner = new DirtyableFlexTable();
        for (int i = 0; i < this.model.fieldValues.length; ++i) {
            ActionFieldValue val = this.model.fieldValues[i];
            inner.setWidget(i, 0, this.fieldSelector(val));
            inner.setWidget(i, 1, this.valueEditor(val));
            int idx = i;
            ImageButton remove = new ImageButton("images/delete_item_small.gif");
            remove.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            inner.setWidget(i, 2, (Widget)remove);
        }
        this.layout.setWidget(0, 1, (Widget)inner);
    }

    private Widget getSetterLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        ImageButton edit = new ImageButton("images/edit_tiny.gif");
        edit.setTitle(this.constants.AddAnotherFieldToThisSoYouCanSetItsValue());
        2 clk = new /* Unavailable Anonymous Inner Class!! */;
        edit.addClickListener((ClickListener)clk);
        String modifyType = "set";
        if (this.model instanceof ActionUpdateField) {
            modifyType = "modify";
        }
        String sl = Format.format((String)this.constants.setterLabel(), (String[])new String[]{HumanReadable.getActionDisplayName((String)modifyType), this.model.variable});
        ClickableLabel lbl = new ClickableLabel(sl, (ClickListener)clk);
        horiz.add((Widget)lbl);
        horiz.add((Widget)edit);
        return horiz;
    }

    protected void showAddFieldPopup(Widget w) {
        FormStylePopup popup = new FormStylePopup("images/newex_wiz.gif", this.constants.AddAField());
        ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletions.length; ++i) {
            box.addItem(this.fieldCompletions[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(this.constants.AddField(), (Widget)box);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    private Widget valueEditor(ActionFieldValue val) {
        String type = "";
        if (this.completions.isGlobalVariable(this.model.variable)) {
            type = (String)this.completions.globalTypes.get(this.model.variable);
        } else {
            type = this.modeller.getModel().getBoundFact((String)this.model.variable).factType;
            if (type == null) {
                type = this.modeller.getModel().getRhsBoundFact((String)this.model.variable).factType;
            }
        }
        DropDownData enums = this.completions.getEnums(type, this.model.fieldValues, val.field);
        return new ActionValueEditor(val, enums, this.modeller, val.type);
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.field);
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    static /* synthetic */ Constants access$000(ActionSetFieldWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ ActionSetField access$100(ActionSetFieldWidget x0) {
        return x0.model;
    }

    static /* synthetic */ RuleModeller access$200(ActionSetFieldWidget x0) {
        return x0.modeller;
    }

    static /* synthetic */ String access$300(ActionSetFieldWidget x0) {
        return x0.variableClass;
    }

    static /* synthetic */ SuggestionCompletionEngine access$400(ActionSetFieldWidget x0) {
        return x0.completions;
    }
}

