/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.explorer.Preferences;
import org.drools.guvnor.client.modeldriven.ui.DatePicker;

public class DatePicker
extends DirtyableComposite {
    DatePickerPopUp datePickerPopUp = new DatePickerPopUp(this);
    Panel panel = new SimplePanel();
    TextBox textWidget = new TextBox();
    protected Label labelWidget = new Label();
    protected String visualFormat = "";
    protected static final String defaultFormat = Preferences.getStringPref((String)"drools.dateformat");
    protected DateTimeFormat formatter = null;
    private List<ValueChanged> valueChangeds = new ArrayList();

    public DatePicker(String selectedDate) {
        this(selectedDate, defaultFormat);
    }

    public DatePicker(String selectedDate, String visualFormat) {
        this.visualFormat = visualFormat;
        if (visualFormat == null || visualFormat.equals("default") || visualFormat.equals("")) {
            visualFormat = defaultFormat;
        }
        this.formatter = DateTimeFormat.getFormat((String)visualFormat);
        this.labelWidget.setStyleName("x-form-field");
        this.labelWidget.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        try {
            this.formatter.parse(selectedDate);
        }
        catch (Exception e) {
            selectedDate = this.formatter.format(new Date());
        }
        if (selectedDate != null && !selectedDate.equals("")) {
            this.textWidget.setText(selectedDate);
            this.labelWidget.setText(selectedDate);
        }
        this.textWidget.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.panel.add((Widget)this.labelWidget);
        this.initWidget((Widget)this.panel);
    }

    public String getVisualFormat() {
        return this.visualFormat;
    }

    public String getDateString() {
        DateTimeFormat formatter = DateTimeFormat.getFormat((String)defaultFormat);
        Date date = this.formatter.parse(this.textWidget.getText());
        return formatter.format(date);
    }

    private void valueChanged() {
        for (ValueChanged changed : this.valueChangeds) {
            changed.valueChanged(this.getDateString());
        }
    }

    public void addValueChanged(ValueChanged listener) {
        this.valueChangeds.add(listener);
    }

    public void removeValueChanged(ValueChanged listener) {
        this.valueChangeds.remove(listener);
    }

    static /* synthetic */ void access$000(DatePicker x0) {
        x0.valueChanged();
    }
}

