/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializableException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.util.GuidedDTDRLPersistence;
import org.drools.guvnor.server.util.GuidedDTXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

public class GuidedDTContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializableException {
        GuidedDecisionTable model = GuidedDTXMLPersistence.getInstance().unmarshal(item.getContent());
        asset.content = model;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializableException {
        GuidedDecisionTable data = (GuidedDecisionTable)asset.content;
        if (data.tableName == null) {
            data.tableName = repoAsset.getName();
        }
        repoAsset.updateContent(GuidedDTXMLPersistence.getInstance().marshal(data));
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        String drl = this.getSourceDRL(asset, builder);
        if (drl.equals("")) {
            return;
        }
        builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuffer buf) {
        String drl = this.getSourceDRL(asset, builder);
        buf.append(drl);
    }

    private String getSourceDRL(AssetItem asset, BRMSPackageBuilder builder) {
        GuidedDecisionTable model = GuidedDTXMLPersistence.getInstance().unmarshal(asset.getContent());
        model.tableName = asset.getName();
        model.parentName = this.parentNameFromCategory(asset, model.parentName);
        String drl = GuidedDTDRLPersistence.getInstance().marshal(model);
        return drl;
    }
}

