/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.contenthandler.RuleFlowHandler;
import org.drools.guvnor.server.repository.MigrateRepository;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.util.ClassicDRLImporter;
import org.drools.guvnor.server.util.FormData;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

@Name(value="fileManager")
@Scope(value=ScopeType.EVENT)
@AutoCreate
public class FileManagerUtils {
    @In
    public RulesRepository repository;

    @Restrict(value="#{identity.loggedIn}")
    public void attachFile(FormData uploadItem) throws IOException {
        String uuid = uploadItem.getUuid();
        InputStream fileData = uploadItem.getFile().getInputStream();
        String fileName = uploadItem.getFile().getName();
        this.attachFileToAsset(uuid, fileData, fileName);
        uploadItem.getFile().getInputStream().close();
    }

    @Restrict(value="#{identity.loggedIn}")
    public void attachFileToAsset(String uuid, InputStream fileData, String fileName) throws IOException {
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        item.updateBinaryContentAttachment(fileData);
        item.updateBinaryContentAttachmentFileName(fileName);
        item.getPackage().updateBinaryUpToDate(false);
        item.checkin("Attached file: " + fileName);
        ContentHandler handler = ContentManager.getHandler((String)item.getFormat());
        if (handler instanceof ModelContentHandler) {
            ((ModelContentHandler)handler).modelAttached(item);
        } else if (handler instanceof RuleFlowHandler) {
            ((RuleFlowHandler)handler).ruleFlowAttached(item);
        }
    }

    public RulesRepository getRepository() {
        return this.repository;
    }

    @Restrict(value="#{identity.loggedIn}")
    public String loadFileAttachmentByUUID(String uuid, OutputStream out) throws IOException {
        AssetItem item = this.repository.loadAssetByUUID(uuid);
        byte[] data = item.getBinaryContentAsBytes();
        if (data == null) {
            data = new byte[]{};
        }
        out.write(data);
        out.flush();
        return item.getName() + "." + item.getFormat();
    }

    public static FormData getFormData(HttpServletRequest request) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        FormData data = new FormData();
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField() && item.getFieldName().equals("attachmentUUID")) {
                    data.setUuid(item.getString());
                    continue;
                }
                if (item.isFormField()) continue;
                data.setFile(item);
            }
            return data;
        }
        catch (FileUploadException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    public String loadBinaryPackage(String packageName, String packageVersion, boolean isLatest, OutputStream out) throws IOException {
        PackageItem item = null;
        if (isLatest) {
            item = this.repository.loadPackage(packageName);
            byte[] data = item.getCompiledPackageBytes();
            out.write(data);
            out.flush();
            return packageName + ".pkg";
        }
        item = this.repository.loadPackageSnapshot(packageName, packageVersion);
        byte[] data = item.getCompiledPackageBytes();
        out.write(data);
        out.flush();
        return packageName + "_" + URLEncoder.encode(packageVersion, "UTF-8") + ".pkg";
    }

    public String loadSourcePackage(String packageName, String packageVersion, boolean isLatest, OutputStream out) throws IOException {
        PackageItem item = null;
        if (isLatest) {
            item = this.repository.loadPackage(packageName);
            ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
            String drl = asm.getDRL();
            out.write(drl.getBytes());
            out.flush();
            return packageName + ".drl";
        }
        item = this.repository.loadPackageSnapshot(packageName, packageVersion);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        String drl = asm.getDRL();
        out.write(drl.getBytes());
        out.flush();
        return packageName + "_" + URLEncoder.encode(packageVersion, "UTF-8") + ".drl";
    }

    public byte[] exportPackageFromRepository(String packageName) {
        try {
            return this.repository.exportPackageFromRepository(packageName);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    public void exportRulesRepository(OutputStream out) {
        this.repository.exportRulesRepositoryToStream(out);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void importRulesRepository(InputStream in) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        this.repository.importRulesRepositoryFromStream(in);
        try {
            if (MigrateRepository.needsRuleflowMigration((RulesRepository)this.repository)) {
                MigrateRepository.migrateRuleflows((RulesRepository)this.repository);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public void importPackageToRepository(byte[] data, boolean importAsNew) {
        this.repository.importPackageToRepository(data, importAsNew);
        try {
            if (MigrateRepository.needsRuleflowMigration((RulesRepository)this.repository)) {
                MigrateRepository.migrateRuleflows((RulesRepository)this.repository);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public void importClassicDRL(InputStream drlStream) throws IOException, DroolsParserException {
        ClassicDRLImporter imp = new ClassicDRLImporter(drlStream);
        PackageItem pkg = null;
        String packageName = imp.getPackageName();
        boolean existing = this.repository.containsPackage(packageName);
        if (existing && this.repository.isPackageArchived(packageName)) {
            PackageItem item = this.repository.loadPackage(packageName);
            item.remove();
            existing = false;
        }
        if (existing) {
            pkg = this.repository.loadPackage(packageName);
            ServiceImplementation.updateDroolsHeader((String)ClassicDRLImporter.mergeLines((String)ServiceImplementation.getDroolsHeader((PackageItem)pkg), (String)imp.getPackageHeader()), (PackageItem)pkg);
            existing = true;
        } else {
            pkg = this.repository.createPackage(packageName, "<imported>");
            ServiceImplementation.updateDroolsHeader((String)imp.getPackageHeader(), (PackageItem)pkg);
        }
        boolean newVer = Boolean.parseBoolean(System.getProperty("drools.createNewVersionOnImport", "true"));
        for (ClassicDRLImporter.Asset as : imp.getAssets()) {
            AssetItem asset;
            if (existing && pkg.containsAsset(as.name)) {
                asset = pkg.loadAsset(as.name);
                if (!asset.getFormat().equals(as.format)) continue;
                asset.updateContent(as.content);
                if (!newVer) continue;
                asset.checkin("Imported change form external DRL");
                continue;
            }
            asset = pkg.addAsset(as.name, "<imported>");
            asset.updateFormat(as.format);
            asset.updateContent(as.content);
            asset.updateExternalSource("Imported from external DRL");
            if (!newVer) continue;
            asset.checkin("Imported change form external DRL");
        }
        this.repository.save();
    }

    public long getLastModified(String name, String version) {
        PackageItem item = null;
        item = version.equals("LATEST") ? this.repository.loadPackage(name) : this.repository.loadPackageSnapshot(name, version);
        return item.getLastModified().getTimeInMillis();
    }

    public String loadSourceAsset(String packageName, String packageVersion, boolean isLatest, String assetName, ByteArrayOutputStream out) throws IOException {
        PackageItem pkg = null;
        pkg = isLatest ? this.repository.loadPackage(packageName) : this.repository.loadPackageSnapshot(packageName, packageVersion);
        AssetItem item = pkg.loadAsset(assetName);
        ContentHandler handler = ContentManager.getHandler((String)item.getFormat());
        StringBuffer buf = new StringBuffer();
        if (handler.isRuleAsset()) {
            BRMSPackageBuilder builder = new BRMSPackageBuilder();
            builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)item.getPackage(), (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
            ((IRuleAsset)handler).assembleDRL(builder, item, buf);
            out.write(buf.toString().getBytes());
            return item.getName() + ".drl";
        }
        out.write(item.getContent().getBytes());
        return item.getName() + ".drl";
    }

    @Destroy
    public void close() {
        this.repository.logout();
    }
}

