/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.drools.guvnor.server.files.FileManagerUtils;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.util.FormData;
import org.drools.guvnor.server.util.LoggingHelper;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

public class RepositoryBackupServlet
extends RepositoryServlet {
    private static final Logger log = LoggingHelper.getLogger(RepositoryBackupServlet.class);
    private static final long serialVersionUID = 400L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        response.setContentType("text/html");
        FormData uploadItem = FileManagerUtils.getFormData((HttpServletRequest)request);
        String packageImport = request.getParameter("packageImport");
        if ("true".equals(packageImport)) {
            boolean importAsNew = "true".equals(request.getParameter("importAsNew"));
            response.getWriter().write(this.processImportPackage(uploadItem.getFile().getInputStream(), importAsNew));
        } else {
            response.getWriter().write(this.processImportRepository(uploadItem.getFile().getInputStream()));
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "admin");
        }
        try {
            String packageName = req.getParameter("packageName");
            if (packageName == null) {
                this.processExportRepositoryDownload(res);
            } else {
                this.processExportPackageFromRepositoryDownload(res, packageName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(new PrintWriter((OutputStream)res.getOutputStream()));
        }
    }

    private void processExportRepositoryDownload(HttpServletResponse res) throws PathNotFoundException, IOException, RepositoryException {
        log.debug((Object)"Exporting...");
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "attachment; filename=repository_export.zip;");
        log.debug((Object)"Starting to process export");
        ZipOutputStream zout = new ZipOutputStream((OutputStream)res.getOutputStream());
        zout.putNextEntry(new ZipEntry("repository_export.xml"));
        this.getFileManager().exportRulesRepository((OutputStream)zout);
        zout.closeEntry();
        zout.finish();
        res.getOutputStream().flush();
        log.debug((Object)"Done exporting!");
    }

    private void processExportPackageFromRepositoryDownload(HttpServletResponse res, String packageName) throws PathNotFoundException, IOException, RepositoryException {
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "inline; filename=" + packageName + ".zip;");
        res.getOutputStream().write(this.getFileManager().exportPackageFromRepository(packageName));
        res.getOutputStream().flush();
    }

    private String processImportRepository(InputStream file) throws IOException {
        this.getFileManager().importRulesRepository(file);
        return "OK";
    }

    private String processImportPackage(InputStream file, boolean importAsNew) throws IOException {
        byte[] byteArray = new byte[file.available()];
        file.read(byteArray);
        this.getFileManager().importPackageToRepository(byteArray, importAsNew);
        return "OK";
    }
}

