/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.drools.guvnor.client.rpc.SecurityService;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.server.security.CapabilityCalculator;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.util.DateUtils;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.permission.RoleBasedPermissionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SecurityServiceImpl
implements SecurityService {
    public static final String GUEST_LOGIN = "guest";
    private static final Logger log = Logger.getLogger(SecurityServiceImpl.class);
    static final Map<String, String> PREFERENCES = SecurityServiceImpl.loadPrefs();

    public boolean login(String userName, String password) {
        log.info((Object)("Logging in user [" + userName + "]"));
        if (Contexts.isApplicationContextActive()) {
            char[] bannedChars = new char[]{'\'', '*', '[', ']'};
            for (int i = 0; i < bannedChars.length; ++i) {
                char c = bannedChars[i];
                if (userName.indexOf(c) < 0) continue;
                log.error((Object)("Not a valid name character " + c));
                return false;
            }
            Identity.instance().getCredentials().setUsername(userName);
            Identity.instance().getCredentials().setPassword(password);
            try {
                Identity.instance().authenticate();
            }
            catch (LoginException e) {
                log.error((Object)e);
                return false;
            }
            return Identity.instance().isLoggedIn();
        }
        return true;
    }

    public UserSecurityContext getCurrentUser() {
        if (Contexts.isApplicationContextActive()) {
            if (!Identity.instance().isLoggedIn()) {
                return new UserSecurityContext(this.checkAutoLogin());
            }
            return new UserSecurityContext(Identity.instance().getCredentials().getUsername());
        }
        HashSet disabled = new HashSet();
        return new UserSecurityContext("SINGLE USER MODE (DEBUG) USE ONLY");
    }

    private String checkAutoLogin() {
        Identity id = Identity.instance();
        id.getCredentials().setUsername("guest");
        try {
            id.authenticate();
        }
        catch (LoginException e) {
            return null;
        }
        if (id.isLoggedIn()) {
            return id.getCredentials().getUsername();
        }
        return null;
    }

    public Capabilities getUserCapabilities() {
        if (Contexts.isApplicationContextActive()) {
            RoleBasedPermissionResolver resolver;
            if (Identity.instance().hasRole("admin")) {
                return Capabilities.all((Map)PREFERENCES);
            }
            CapabilityCalculator c = new CapabilityCalculator();
            RoleBasedPermissionManager permManager = (RoleBasedPermissionManager)Component.getInstance((String)"roleBasedPermissionManager");
            List permissions = permManager.getRoleBasedPermission();
            if (permissions.size() == 0 && (resolver = (RoleBasedPermissionResolver)Component.getInstance((String)"org.jboss.seam.security.roleBasedPermissionResolver")).isEnableRoleBasedAuthorization()) {
                Identity.instance().logout();
                throw new AuthorizationException("This user has no permissions setup.");
            }
            return c.calcCapabilities(permissions, PREFERENCES);
        }
        return Capabilities.all((Map)PREFERENCES);
    }

    private static Map<String, String> loadPrefs() {
        Properties ps = new Properties();
        try {
            ps.load(SecurityServiceImpl.class.getResourceAsStream("/preferences.properties"));
            HashMap<String, String> prefs = new HashMap<String, String>();
            for (Object o : ps.keySet()) {
                String feature = (String)o;
                prefs.put(feature, ps.getProperty(feature));
            }
            SecurityServiceImpl.setSystemProperties(prefs);
            return prefs;
        }
        catch (IOException e) {
            log.info((Object)"Couldn't find preferences.properties - using defaults");
            return new HashMap<String, String>();
        }
    }

    private static void setSystemProperties(Map<String, String> prefs) {
        String dateFormat = "drools.dateformat";
        String defaultLanguage = "drools.defaultlanguage";
        String defaultCountry = "drools.defaultcountry";
        if (prefs.containsKey("drools.dateformat")) {
            System.setProperty("drools.dateformat", prefs.get("drools.dateformat"));
        }
        if (prefs.containsKey("drools.defaultlanguage")) {
            System.setProperty("drools.defaultlanguage", prefs.get("drools.defaultlanguage"));
        }
        if (prefs.containsKey("drools.defaultcountry")) {
            System.setProperty("drools.defaultcountry", prefs.get("drools.defaultcountry"));
        }
        if (!prefs.containsKey("drools.dateformat")) {
            prefs.put("drools.dateformat", DateUtils.getDateFormatMask());
        }
        if (!prefs.containsKey("drools.defaultlanguage")) {
            prefs.put("drools.defaultlanguage", System.getProperty("drools.defaultlanguage"));
        }
        if (!prefs.containsKey("drools.defaultcountry")) {
            prefs.put("drools.defaultcountry", System.getProperty("drools.defaultcountry"));
        }
    }
}

