/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.selector;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.drools.CheckedDroolsException;
import org.drools.RuleBase;
import org.drools.RuntimeDroolsException;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.compiler.RuleBaseLoader;
import org.drools.guvnor.server.selector.Allow;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.repository.AssetItem;

public class RuleBasedSelector
implements AssetSelector {
    private static final Logger log = Logger.getLogger(RuleBasedSelector.class);
    String ruleFile;
    private RuleBase ruleBase;

    public RuleBasedSelector(String val) {
        this.ruleFile = val;
        InputStream ins = this.getClass().getResourceAsStream(this.ruleFile);
        InputStreamReader reader = new InputStreamReader(ins);
        try {
            this.ruleBase = RuleBaseLoader.getInstance().loadFromReader((Reader)reader);
        }
        catch (CheckedDroolsException e) {
            log.error((Object)e);
            throw new RuntimeDroolsException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new RuntimeDroolsException((Throwable)e);
        }
    }

    public boolean isAssetAllowed(AssetItem asset) {
        return this.evalRules((Object)asset);
    }

    boolean evalRules(Object asset) {
        StatelessSession session = this.ruleBase.newStatelessSession();
        StatelessSessionResult result = session.executeWithResults(asset);
        Iterator objects = result.iterateObjects();
        while (objects.hasNext()) {
            if (!(objects.next() instanceof Allow)) continue;
            return true;
        }
        return false;
    }
}

