/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rulelist.EditItemEvent;

public class BulkRunResultWidget
extends Composite {
    private BulkTestRunResult result;
    private EditItemEvent editEvent;
    private PrettyFormLayout layout;
    private SimplePanel parent;
    private Command close;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public BulkRunResultWidget(BulkTestRunResult result, EditItemEvent editEvent, Command close) {
        this.close = close;
        this.result = result;
        this.editEvent = editEvent;
        this.parent = new SimplePanel();
        if (result.result != null && result.result.lines != null && result.result.lines.length > 0) {
            this.showErrors();
        } else {
            this.showResult();
        }
        this.initWidget((Widget)this.parent);
    }

    private void showResult() {
        this.clear();
        int grandTotal = 0;
        int totalFailures = 0;
        FlexTable summaryTable = new FlexTable();
        ScenarioResultSummary[] summaries = this.result.results;
        for (int i = 0; i < summaries.length; ++i) {
            ScenarioResultSummary s = summaries[i];
            grandTotal += s.total;
            totalFailures += s.failures;
            summaryTable.setWidget(i, 0, (Widget)new SmallLabel(s.scenarioName + ":"));
            summaryTable.getFlexCellFormatter().setHorizontalAlignment(i, 0, HasHorizontalAlignment.ALIGN_RIGHT);
            if (s.failures > 0) {
                summaryTable.setWidget(i, 1, ScenarioWidget.getBar((String)"#CC0000", (int)150, (int)(s.total - s.failures), (int)s.total));
            } else {
                summaryTable.setWidget(i, 1, ScenarioWidget.getBar((String)"GREEN", (int)150, (float)100.0f));
            }
            summaryTable.setWidget(i, 2, (Widget)new SmallLabel(Format.format((String)this.constants.TestFailureBulkFailures(), (int)s.failures, (int)s.total)));
            Button open = new Button(this.constants.Open());
            open.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            summaryTable.setWidget(i, 3, (Widget)open);
        }
        summaryTable.setWidth("100%");
        HorizontalPanel resultsH = new HorizontalPanel();
        if (totalFailures > 0) {
            resultsH.add(ScenarioWidget.getBar((String)"#CC0000", (int)300, (int)totalFailures, (int)grandTotal));
        } else {
            resultsH.add(ScenarioWidget.getBar((String)"GREEN", (int)300, (float)100.0f));
        }
        resultsH.add((Widget)new SmallLabel("&nbsp;" + Format.format((String)this.constants.failuresOutOFExpectations(), (int)totalFailures, (int)grandTotal)));
        this.layout.startSection();
        this.layout.addAttribute(this.constants.OverallResult(), (Widget)new HTML(totalFailures == 0 ? this.constants.SuccessOverall() : this.constants.FailureOverall()));
        this.layout.addAttribute(this.constants.Results(), (Widget)resultsH);
        HorizontalPanel coveredH = new HorizontalPanel();
        if (this.result.percentCovered < 100) {
            coveredH.add(ScenarioWidget.getBar((String)"YELLOW", (int)300, (float)this.result.percentCovered));
        } else {
            coveredH.add(ScenarioWidget.getBar((String)"GREEN", (int)300, (float)100.0f));
        }
        coveredH.add((Widget)new SmallLabel("&nbsp;" + Format.format((String)this.constants.RuleCoveragePercent(), (int)this.result.percentCovered)));
        this.layout.addAttribute(this.constants.RulesCovered(), (Widget)coveredH);
        if (this.result.percentCovered < 100) {
            ListBox uncoveredRules = new ListBox();
            for (int i = 0; i < this.result.rulesNotCovered.length; ++i) {
                uncoveredRules.addItem(this.result.rulesNotCovered[i]);
            }
            uncoveredRules.setMultipleSelect(true);
            if (this.result.rulesNotCovered.length > 20) {
                uncoveredRules.setVisibleItemCount(20);
            } else {
                uncoveredRules.setVisibleItemCount(this.result.rulesNotCovered.length);
            }
            this.layout.addAttribute(this.constants.UncoveredRules(), (Widget)uncoveredRules);
        }
        this.layout.endSection();
        this.layout.startSection(this.constants.Scenarios());
        this.layout.addAttribute("", (Widget)summaryTable);
        Button c = new Button(this.constants.Close());
        c.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.addRow((Widget)c);
        this.layout.endSection();
    }

    private void clear() {
        this.parent.clear();
        this.layout = new PrettyFormLayout();
        this.parent.add((Widget)this.layout);
    }

    private void showErrors() {
        this.clear();
        BuilderResult errors = this.result.result;
        SimplePanel err = new SimplePanel();
        PackageBuilderWidget.showBuilderErrors((BuilderResult)errors, (Panel)err, (EditItemEvent)this.editEvent);
        this.layout.startSection(this.constants.BuildErrorsUnableToRunScenarios());
        this.layout.addRow((Widget)err);
        this.layout.endSection();
    }

    static /* synthetic */ EditItemEvent access$000(BulkRunResultWidget x0) {
        return x0.editEvent;
    }

    static /* synthetic */ Command access$100(BulkRunResultWidget x0) {
        return x0.close;
    }
}

