/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.qa.testscenarios.DataInputWidget;
import org.drools.guvnor.client.qa.testscenarios.FieldDataConstraintEditor;
import org.drools.guvnor.client.qa.testscenarios.ScenarioWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.FixtureList;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class DataInputWidget
extends DirtyableFlexTable {
    private final Scenario scenario;
    private final SuggestionCompletionEngine suggestionCompletionEngine;
    protected final String type;
    private final ScenarioWidget parent;
    private final ExecutionTrace executionTrace;
    private final FixtureList definitionList;
    private final String headerText;
    protected static Constants constants = (Constants)GWT.create(Constants.class);

    public DataInputWidget(String factType, FixtureList definitionList, Scenario sc, ScenarioWidget parent, ExecutionTrace executionTrace, String headerText) {
        this.scenario = sc;
        this.suggestionCompletionEngine = parent.suggestionCompletionEngine;
        this.type = factType;
        this.parent = parent;
        this.executionTrace = executionTrace;
        this.definitionList = definitionList;
        this.headerText = headerText;
        this.setStyles();
        this.render();
    }

    private void setStyles() {
        this.getCellFormatter().setStyleName(0, 0, "modeller-fact-TypeHeader");
        this.getCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        this.setStyleName("modeller-fact-pattern-Widget");
    }

    protected ClickHandler addFieldClickHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void render() {
        this.clear();
        this.setWidget(0, 0, (Widget)new ClickableLabel(this.headerText, this.addFieldClickHandler()));
        if (this.definitionList.size() == 0) {
            this.parent.renderEditor();
        }
        RowIndexByFieldName rowIndexByFieldName = new RowIndexByFieldName(this);
        int col = 0;
        int totalCols = this.definitionList.size();
        for (Fixture fixture : this.definitionList) {
            if (!(fixture instanceof FactData)) continue;
            FactData factData = (FactData)fixture;
            this.setWidget(0, ++col, (Widget)new SmallLabel("[" + factData.name + "]"));
            HashMap presentFields = new HashMap();
            for (FieldData fieldData : factData.fieldData) {
                if (rowIndexByFieldName.doesNotContain(fieldData.name)) {
                    this.newRow(rowIndexByFieldName, totalCols, factData.name, fieldData.name);
                }
                int fieldRowIndex = rowIndexByFieldName.getRowIndex(fieldData.name);
                this.setWidget(fieldRowIndex, col, this.editableCell(fieldData, factData, factData.type, this.executionTrace));
                presentFields.remove(fieldData.name);
            }
            for (Map.Entry entry : presentFields.entrySet()) {
                int fieldRow = (Integer)entry.getValue();
                FieldData fieldData = new FieldData((String)entry.getKey(), "");
                factData.fieldData.add(fieldData);
                this.setWidget(fieldRow, col, this.editableCell(fieldData, factData, factData.type, this.executionTrace));
            }
            this.setWidget(rowIndexByFieldName.amountOrRows() + 1, col, (Widget)new DeleteFactColumnButton(this, factData));
        }
        int totalRows = rowIndexByFieldName.amountOrRows();
        this.getFlexCellFormatter().setHorizontalAlignment(totalRows + 1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        if (totalRows == 0) {
            Button b = new Button(constants.AddAField());
            b.addClickHandler(this.addFieldClickHandler());
            this.setWidget(1, 1, (Widget)b);
        }
    }

    private void newRow(RowIndexByFieldName rowIndexByFieldName, int totalCols, String factName, String fieldName) {
        rowIndexByFieldName.addRow(fieldName);
        int rowIndex = rowIndexByFieldName.getRowIndex(fieldName);
        this.setWidget(rowIndex, 0, (Widget)new SmallLabel(fieldName + ":"));
        this.setWidget(rowIndex, totalCols + 1, (Widget)new DeleteFieldRowButton(this, factName, fieldName));
        this.getCellFormatter().setHorizontalAlignment(rowIndex, 0, HasHorizontalAlignment.ALIGN_RIGHT);
    }

    private Widget editableCell(FieldData fd, FactData factData, String factType, ExecutionTrace executionTrace) {
        return new FieldDataConstraintEditor(factType, (ValueChanged)new /* Unavailable Anonymous Inner Class!! */, fd, factData, this.suggestionCompletionEngine, this.scenario, executionTrace);
    }

    static /* synthetic */ FixtureList access$000(DataInputWidget x0) {
        return x0.definitionList;
    }

    static /* synthetic */ SuggestionCompletionEngine access$100(DataInputWidget x0) {
        return x0.suggestionCompletionEngine;
    }

    static /* synthetic */ void access$200(DataInputWidget x0) {
        x0.render();
    }

    static /* synthetic */ Scenario access$300(DataInputWidget x0) {
        return x0.scenario;
    }
}

