/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.Panel;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.CategoriesPanel;
import org.drools.guvnor.client.explorer.ExplorerLayoutManager;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.PushClient;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.ServerPushNotification;
import org.drools.guvnor.client.security.Capabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussionWidget
extends Composite {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private VerticalPanel commentList = new VerticalPanel();
    private VerticalPanel newCommentLayout = new VerticalPanel();
    private RuleAsset asset;
    private ServerPushNotification pushNotify;
    private int lastCount = 0;

    protected void onUnload() {
        super.onUnload();
        PushClient.instance().unsubscribe(this.pushNotify);
    }

    public DiscussionWidget(RuleAsset asset) {
        this.asset = asset;
        Panel discussionPanel = new Panel();
        discussionPanel.setCollapsible(true);
        discussionPanel.setTitle(constants.Discussion() + ":");
        discussionPanel.setBodyBorder(false);
        this.commentList.setWidth("100%");
        VerticalPanel discussionLayout = new VerticalPanel();
        discussionLayout.setWidth("100%");
        discussionPanel.add((Widget)discussionLayout);
        discussionLayout.add((Widget)this.commentList);
        this.newCommentLayout.setWidth("100%");
        this.refreshDiscussion();
        discussionLayout.add((Widget)this.newCommentLayout);
        this.showNewCommentButton();
        this.pushNotify = new /* Unavailable Anonymous Inner Class!! */;
        PushClient.instance().subscribe(this.pushNotify);
        this.initWidget((Widget)discussionPanel);
    }

    public void refreshDiscussion() {
        RepositoryServiceFactory.getService().loadDiscussionForAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateCommentList(List<DiscussionRecord> ls) {
        if (ls.size() == this.lastCount) {
            return;
        }
        this.commentList.clear();
        for (DiscussionRecord dr : ls) {
            this.appendComment(dr);
        }
        this.lastCount = ls.size();
    }

    private Widget appendComment(DiscussionRecord r) {
        SmallLabel hrd = new SmallLabel(Format.format((String)constants.smallCommentBy0On1Small(), (String)r.author, (String)new Date(r.timestamp).toString()));
        hrd.addStyleName("discussion-header");
        this.commentList.add((Widget)hrd);
        Label lbl = new Label(r.note);
        lbl.setStyleName("x-form-field");
        this.commentList.add((Widget)lbl);
        this.commentList.add((Widget)new HTML("<br/>"));
        return hrd;
    }

    private void showNewCommentButton() {
        this.newCommentLayout.clear();
        HorizontalPanel hp = new HorizontalPanel();
        Button createNewComment = new Button(constants.AddADiscussionComment());
        hp.add((Widget)createNewComment);
        if (ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_ADMIN})) {
            Button adminClearAll = new Button(constants.EraseAllComments());
            hp.add((Widget)adminClearAll);
            adminClearAll.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        String feedURL = GWT.getModuleBaseURL() + "feed/discussion?package=" + this.asset.metaData.packageName + "&assetName=" + URL.encode((String)this.asset.metaData.name) + "&viewUrl=" + CategoriesPanel.getSelfURL();
        hp.add((Widget)new HTML("<a href='" + feedURL + "' target='_blank'><img src='images/feed.png'/></a>"));
        this.newCommentLayout.add((Widget)hp);
        this.newCommentLayout.setCellHorizontalAlignment((Widget)hp, HasHorizontalAlignment.ALIGN_RIGHT);
        createNewComment.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showAddNewComment() {
        this.newCommentLayout.clear();
        TextArea comment = new TextArea();
        comment.setWidth("100%");
        this.newCommentLayout.add((Widget)comment);
        Button ok = new Button(constants.OK());
        Button cancel = new Button(constants.Cancel());
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        cancel.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)ok);
        hp.add((Widget)cancel);
        this.newCommentLayout.add((Widget)hp);
        comment.setFocus(true);
    }

    private void sendNewComment(String text) {
        this.newCommentLayout.clear();
        this.newCommentLayout.add((Widget)new Image("images/spinner.gif"));
        RepositoryServiceFactory.getService().addToDiscussionForAsset(this.asset.uuid, text, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(DiscussionWidget x0, List x1) {
        x0.updateCommentList(x1);
    }

    static /* synthetic */ Constants access$100() {
        return constants;
    }

    static /* synthetic */ RuleAsset access$200(DiscussionWidget x0) {
        return x0.asset;
    }

    static /* synthetic */ void access$300(DiscussionWidget x0) {
        x0.showAddNewComment();
    }

    static /* synthetic */ void access$400(DiscussionWidget x0, String x1) {
        x0.sendNewComment(x1);
    }

    static /* synthetic */ void access$500(DiscussionWidget x0) {
        x0.showNewCommentButton();
    }
}

