/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.util.LoggingHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class GuvnorAPIServlet
extends HttpServlet {
    private static final LoggingHelper log = LoggingHelper.getLogger(GuvnorAPIServlet.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Incoming request for Guvnor API:" + request.getRequestURL());
        String action = request.getParameter("action");
        if (!"load".equals(action)) throw new ServletException((Throwable)new IllegalArgumentException("The servlet requires a parameter named action"));
        String uuid = request.getParameter("uuid");
        if (uuid == null) {
            throw new ServletException((Throwable)new IllegalArgumentException("The load action requires the parameter uuid"));
        }
        try {
            RuleAsset asset = RepositoryServiceServlet.getService().loadRuleAsset(uuid);
            if (asset.content == null) return;
            response.setContentType("application/json");
            String content = null;
            content = asset.content instanceof RuleFlowContentModel ? ((RuleFlowContentModel)asset.content).getXml() : asset.content.toString();
            try {
                content = GuvnorAPIServlet.deserialize((String)"http://localhost:8080/designer/bpmn2_0deserialization", (String)content);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            log.debug("Sending model");
            log.debug(content);
            log.debug("End of sending model");
            response.setContentLength(content.getBytes().length);
            response.getOutputStream().write(content.getBytes());
            response.getOutputStream().close();
            return;
        }
        catch (SerializationException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deserialize(String deserializeUrl, String modelXml) throws IOException {
        OutputStream out = null;
        InputStream content = null;
        ByteArrayOutputStream bos = null;
        try {
            URL bpmn2_0SerializationURL = new URL(deserializeUrl);
            modelXml = "data=" + URLEncoder.encode(modelXml, "UTF-8");
            byte[] bytes = modelXml.getBytes("UTF-8");
            HttpURLConnection connection = (HttpURLConnection)bpmn2_0SerializationURL.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setFixedLengthStreamingMode(bytes.length);
            connection.setDoOutput(true);
            out = connection.getOutputStream();
            out.write(bytes);
            out.close();
            content = connection.getInputStream();
            bos = new ByteArrayOutputStream();
            int b = 0;
            while ((b = content.read()) > -1) {
                bos.write(b);
            }
            bytes = bos.toByteArray();
            content.close();
            bos.close();
            String string = new String(bytes);
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (content != null) {
                    content.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

