/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.DroolsParserException;
import org.drools.doc.DroolsDocsBuilder;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.VersionableItem;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GuvnorDroolsDocsBuilder
extends DroolsDocsBuilder {
    private static List<String> formats = new ArrayList();

    private GuvnorDroolsDocsBuilder(PackageItem packageItem) throws DroolsParserException {
        super(GuvnorDroolsDocsBuilder.createDrlPackageData((PackageItem)packageItem));
    }

    protected static DrlPackageParser createDrlPackageData(PackageItem packageItem) {
        ArrayList<DrlRuleParser> rules = new ArrayList<DrlRuleParser>();
        Iterator assets = packageItem.getAssets();
        while (assets.hasNext()) {
            String drl;
            AssetItem assetItem = (AssetItem)assets.next();
            if (!formats.contains(assetItem.getFormat()) || assetItem.getDisabled() || assetItem.isArchived() || (drl = GuvnorDroolsDocsBuilder.getDRL((AssetItem)assetItem)) == null) continue;
            DrlRuleParser ruleData = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
            ArrayList<String> categories = new ArrayList<String>();
            for (CategoryItem ci : assetItem.getCategories()) {
                categories.add(ci.getName());
            }
            ruleData.getOtherInformation().put("Categories", categories);
            ruleData.getMetadata().addAll(GuvnorDroolsDocsBuilder.createMetaData((VersionableItem)assetItem));
            rules.add(ruleData);
        }
        String header = ServiceImplementation.getDroolsHeader((PackageItem)packageItem);
        List globals = DrlPackageParser.findGlobals((String)header);
        return new DrlPackageParser(packageItem.getName(), packageItem.getDescription(), rules, globals, GuvnorDroolsDocsBuilder.createMetaData((VersionableItem)packageItem), new HashMap());
    }

    private static List<String> createMetaData(VersionableItem versionableItem) {
        ArrayList<String> list = new ArrayList<String>();
        Format formatter = GuvnorDroolsDocsBuilder.getFormatter();
        list.add("Creator :" + versionableItem.getCreator());
        list.add("Created date :" + formatter.format(versionableItem.getCreatedDate().getTime()));
        list.add("Last contributor :" + versionableItem.getLastContributor());
        list.add("Last modified :" + formatter.format(versionableItem.getLastModified().getTime()));
        return list;
    }

    public static GuvnorDroolsDocsBuilder getInstance(PackageItem packageItem) throws DroolsParserException {
        return new GuvnorDroolsDocsBuilder(packageItem);
    }

    private static String getDRL(AssetItem item) {
        ContentHandler handler = ContentManager.getHandler((String)item.getFormat());
        StringBuffer buf = new StringBuffer();
        if (!handler.isRuleAsset()) {
            return null;
        }
        BRMSPackageBuilder builder = new BRMSPackageBuilder();
        builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)item.getPackage(), (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
        ((IRuleAsset)handler).assembleDRL(builder, item, buf);
        return buf.toString();
    }

    static {
        formats.add("drl");
        formats.add("brl");
    }
}

