/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.server.security.RoleBasedPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilityCalculator {
    public Capabilities calcCapabilities(List<RoleBasedPermission> permissions, Map<String, String> features) {
        if (permissions.size() == 0) {
            return Capabilities.all(features);
        }
        Capabilities caps = new Capabilities();
        for (RoleBasedPermission p : permissions) {
            String r = p.getRole();
            if (r.equals("admin")) {
                return Capabilities.all(features);
            }
            if (r.equals("package.admin")) {
                this.addCap(caps, Capabilities.SHOW_PACKAGE_VIEW);
                this.addCap(caps, Capabilities.SHOW_CREATE_NEW_ASSET);
                this.addCap(caps, Capabilities.SHOW_CREATE_NEW_PACKAGE);
                this.addCap(caps, Capabilities.SHOW_DEPLOYMENT);
                this.addCap(caps, Capabilities.SHOW_DEPLOYMENT_NEW);
                this.addCap(caps, Capabilities.SHOW_QA);
                continue;
            }
            if (r.equals("package.developer")) {
                this.addCap(caps, Capabilities.SHOW_PACKAGE_VIEW);
                this.addCap(caps, Capabilities.SHOW_CREATE_NEW_ASSET);
                this.addCap(caps, Capabilities.SHOW_QA);
                continue;
            }
            if (!r.equals("package.readonly")) continue;
            this.addCap(caps, Capabilities.SHOW_PACKAGE_VIEW);
        }
        caps.prefs = features;
        return caps;
    }

    private void addCap(Capabilities caps, Integer cap) {
        if (!caps.list.contains(cap)) {
            caps.list.add(cap);
        }
    }
}

