package org.drools.guvnor.client.rpc;
/*
 * Copyright 2005 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



import org.drools.guvnor.client.common.GenericCallback;

import com.google.gwt.user.client.rpc.RemoteService;

/**
 * 
 * This is what the remote service will implement, as a servlet.
 * 
 * (in hosted/debug mode, you could also use an implementation that was
 * in-process).
 */

public interface RepositoryServiceAsync {

    /** PLACE THE FOLLOWING IN RepositoryServiceAsync.java **/

    /** Generated by AsyncInterfaceGenerator hackery */
	void addToDiscussionForAsset(java.lang.String assetId, java.lang.String comment, com.google.gwt.user.client.rpc.AsyncCallback<java.util.List<org.drools.guvnor.client.rpc.DiscussionRecord>> arg3);
	void analysePackage(java.lang.String packageUUID, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.AnalysisReport> arg2);
	void archiveAsset(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void unArchiveAsset(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void archiveAssets(java.lang.String[] uuids, boolean value, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void buildAsset(org.drools.guvnor.client.rpc.RuleAsset asset, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.BuilderResult> arg2);
	void buildAssetSource(org.drools.guvnor.client.rpc.RuleAsset asset, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg2);
	void buildPackage(java.lang.String packageUUID, boolean force, java.lang.String buildMode, java.lang.String operator, java.lang.String statusDescriptionValue, boolean enableStatusSelector, java.lang.String categoryOperator, java.lang.String category, boolean enableCategorySelector, java.lang.String customSelectorName, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.BuilderResult> arg11);
	void buildPackageSource(java.lang.String packageUUID, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg2);
	void changeAssetPackage(java.lang.String uuid, java.lang.String newPackage, java.lang.String comment, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg4);
	void changeState(java.lang.String uuid, java.lang.String newState, boolean wholePackage, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg4);
	void checkinVersion(org.drools.guvnor.client.rpc.RuleAsset asset, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg2);
	void cleanLog(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg1);
	void clearAllDiscussionsForAsset(java.lang.String assetId, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void clearRulesRepository(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg1);
	void compareSnapshots(java.lang.String packageName, java.lang.String firstSnapshotName, java.lang.String secondSnapshotName, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.SnapshotDiffs> arg4);
	void copyAsset(java.lang.String assetUUID, java.lang.String newPackage, java.lang.String newName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg4);
	void copyOrRemoveSnapshot(java.lang.String packageName, java.lang.String snapshotName, boolean delete, java.lang.String newSnapshotName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg5);
	void copyPackage(java.lang.String sourcePackageName, java.lang.String destPackageName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void createCategory(java.lang.String path, java.lang.String name, java.lang.String description, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Boolean> arg4);
	void createNewImportedRule(java.lang.String sharedAssetName, java.lang.String initialPackage, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg3);
	void createNewRule(java.lang.String ruleName, java.lang.String description, java.lang.String initialCategory, java.lang.String initialPackage, java.lang.String format, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg6);
	void createPackage(java.lang.String name, java.lang.String description, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg3);
	void createPackageSnapshot(java.lang.String packageName, java.lang.String snapshotName, boolean replaceExisting, java.lang.String comment, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg5);
	void createState(java.lang.String name, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg2);
	void createSubPackage(java.lang.String name, java.lang.String description, java.lang.String parentPackage, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg4);
	void createUser(java.lang.String userName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void deleteUncheckedRule(java.lang.String ruleName, java.lang.String initialPackage, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void deleteUser(java.lang.String userName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void getAssetLockerUserName(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg2);
	void getCustomSelectors(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String[]> arg1);
	void installSampleRepository(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg1);
	void listArchivedPackages(com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.PackageConfigData[]> arg1);
	void listAssets(java.lang.String packageUUID, java.lang.String[] formats, int skip, int numRows, java.lang.String tableConfig, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg6);
	void listAvailablePermissionTypes(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String[]> arg1);
	void listPackages(com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.PackageConfigData[]> arg1);
	void listRulesInPackage(java.lang.String packageName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String[]> arg2);
	void listSnapshots(java.lang.String packageName, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.SnapshotInfo[]> arg2);
	void listStates(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String[]> arg1);
	void listTypesInPackage(java.lang.String packageUUID, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String[]> arg2);
	void listUserPermissions(com.google.gwt.user.client.rpc.AsyncCallback<java.util.Map<java.lang.String, java.util.List<java.lang.String>>> arg1);
	void loadArchivedAssets(int skip, int numRows, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg3);
	void loadAssetHistory(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg2);
	void loadChildCategories(java.lang.String categoryPath, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String[]> arg2);
	void loadDiscussionForAsset(java.lang.String assetId, com.google.gwt.user.client.rpc.AsyncCallback<java.util.List<org.drools.guvnor.client.rpc.DiscussionRecord>> arg2);
	void loadDropDownExpression(java.lang.String[] valuePairs, java.lang.String expression, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String[]> arg3);
	void loadGlobalPackage(com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.PackageConfigData> arg1);
	void loadInbox(java.lang.String inboxName, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg2);
	void loadPackageConfig(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.PackageConfigData> arg2);
	void loadRuleAsset(java.lang.String UUID, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.RuleAsset> arg2);
	void loadRuleAssets(java.lang.String[] UUIDs, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.RuleAsset[]> arg2);
	void loadRuleListForCategories(java.lang.String categoryPath, int skip, int numRows, java.lang.String tableConfig, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg5);
	void loadRuleListForState(java.lang.String state, int skip, int numRows, java.lang.String tableConfig, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg5);
	void loadSuggestionCompletionEngine(java.lang.String packageName, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine> arg2);
	void loadTableConfig(java.lang.String listName, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableConfig> arg2);
	void lockAsset(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void promoteAssetToGlobalArea(java.lang.String assetUUID, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void queryFullText(java.lang.String text, boolean seekArchived, int skip, int numRows, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg5);
	void queryMetaData(org.drools.guvnor.client.rpc.MetaDataQuery[] qr, java.util.Date createdAfter, java.util.Date createdBefore, java.util.Date modifiedAfter, java.util.Date modifiedBefore, boolean seekArchived, int skip, int numRows, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg9);
	void quickFindAsset(java.lang.String searchText, boolean searchArchived, int skip, int numRows, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.TableDataResult> arg5);
	void rebuildPackages(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg1);
	void rebuildSnapshots(com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg1);
	void removeAsset(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void removeAssets(java.lang.String[] uuids, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void removeCategory(java.lang.String categoryPath, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void removePackage(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void removeState(java.lang.String name, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void renameAsset(java.lang.String uuid, java.lang.String newName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg3);
	void renameCategory(java.lang.String fullPathAndName, java.lang.String newName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void renamePackage(java.lang.String uuid, java.lang.String newName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg3);
	void renameState(java.lang.String oldName, java.lang.String newName, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void restoreVersion(java.lang.String versionUUID, java.lang.String assetUUID, java.lang.String comment, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg4);
	void retrieveUserPermissions(java.lang.String userName, com.google.gwt.user.client.rpc.AsyncCallback<java.util.Map<java.lang.String, java.util.List<java.lang.String>>> arg2);
	void runScenario(java.lang.String packageName, org.drools.ide.common.client.modeldriven.testing.Scenario scenario, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.SingleScenarioResult> arg3);
	void runScenariosInPackage(java.lang.String packageUUID, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.BulkTestRunResult> arg2);
	void savePackage(org.drools.guvnor.client.rpc.PackageConfigData data, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.ValidatedResponse> arg2);
	void showLog(com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.LogEntry[]> arg1);
	void subscribe(com.google.gwt.user.client.rpc.AsyncCallback<java.util.List<org.drools.guvnor.client.rpc.PushResponse>> arg1);
	void unLockAsset(java.lang.String uuid, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg2);
	void updateUserPermissions(java.lang.String userName, java.util.Map<java.lang.String, java.util.List<java.lang.String>> perms, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.Void> arg3);
	void verifyAsset(org.drools.guvnor.client.rpc.RuleAsset asset, java.util.Set<String> sactiveWorkingSets, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.AnalysisReport> arg2);
	void verifyAssetWithoutVerifiersRules(org.drools.guvnor.client.rpc.RuleAsset asset, java.util.Set<String> sactiveWorkingSets, com.google.gwt.user.client.rpc.AsyncCallback<org.drools.guvnor.client.rpc.AnalysisReport> arg2);
}