/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.SortDir;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.DateFieldDef;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.ToolbarItem;
import com.gwtext.client.widgets.ToolbarSeparator;
import com.gwtext.client.widgets.ToolbarTextItem;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import java.util.ArrayList;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

public class LogViewer
extends Composite {
    private VerticalPanel layout;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public LogViewer() {
        this.layout = new VerticalPanel();
        this.layout.setHeight("100%");
        this.layout.setWidth("100%");
        this.refresh();
        this.initWidget((Widget)this.layout);
    }

    private void refresh() {
        LoadingPopup.showMessage((String)this.constants.LoadingLogMessages());
        RepositoryServiceFactory.getService().showLog((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cleanLog() {
        LoadingPopup.showMessage((String)this.constants.CleaningLogMessages());
        RepositoryServiceFactory.getService().cleanLog((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showLogs(LogEntry[] logs) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (int i = 0; i < logs.length; ++i) {
            LogEntry e = logs[i];
            if (e == null) continue;
            entries.add(e);
        }
        Object[][] data = new Object[entries.size()][3];
        for (int i = 0; i < entries.size(); ++i) {
            LogEntry e = (LogEntry)entries.get(i);
            data[i][0] = new Integer(e.severity);
            data[i][1] = e.timestamp;
            data[i][2] = e.message;
        }
        MemoryProxy proxy = new MemoryProxy(data);
        RecordDef recordDef = new RecordDef(new FieldDef[]{new IntegerFieldDef("severity"), new DateFieldDef("timestamp"), new StringFieldDef("message")});
        ArrayReader reader = new ArrayReader(recordDef);
        Store store = new Store((DataProxy)proxy, (Reader)reader);
        store.setDefaultSort("timestamp", SortDir.DESC);
        store.load();
        ColumnModel cm = new ColumnModel((BaseColumnConfig[])new ColumnConfig[]{new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */});
        GridPanel g = new GridPanel(store, cm);
        g.setWidth(800);
        g.setHeight(600);
        Toolbar tb = new Toolbar();
        g.setTopToolbar(tb);
        tb.addItem((ToolbarItem)new ToolbarTextItem(this.constants.ShowRecentLogTip()));
        tb.addItem((ToolbarItem)new ToolbarSeparator());
        this.layout.add((Widget)g);
        ToolbarButton reload = new ToolbarButton(this.constants.Reload());
        reload.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(reload);
        ToolbarButton clean = new ToolbarButton(this.constants.Clean());
        clean.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(clean);
    }

    static /* synthetic */ void access$000(LogViewer x0, LogEntry[] x1) {
        x0.showLogs(x1);
    }

    static /* synthetic */ void access$100(LogViewer x0) {
        x0.refresh();
    }

    static /* synthetic */ Constants access$200(LogViewer x0) {
        return x0.constants;
    }

    static /* synthetic */ VerticalPanel access$300(LogViewer x0) {
        return x0.layout;
    }

    static /* synthetic */ void access$400(LogViewer x0) {
        x0.cleanLog();
    }
}

