/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.BoundTextBox;
import org.drools.guvnor.client.modeldriven.ui.DatePickerLabel;
import org.drools.guvnor.client.modeldriven.ui.DefaultLiteralEditor;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDownLabel;
import org.drools.guvnor.client.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

public class ConstraintValueEditor
extends DirtyableComposite {
    private final FactPattern pattern;
    private final String fieldName;
    private final SuggestionCompletionEngine sce;
    private final ISingleFieldConstraint constraint;
    private final Panel panel;
    private final RuleModel model;
    private final RuleModeller modeller;
    private final boolean numericValue;
    private DropDownData dropDownData;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private String fieldType;
    private boolean readOnly;
    private Command onValueChangeCommand;

    public ConstraintValueEditor(FactPattern pattern, String fieldName, ISingleFieldConstraint con, RuleModeller modeller, String valueType, boolean readOnly) {
        this.pattern = pattern;
        this.fieldName = fieldName;
        this.sce = modeller.getSuggestionCompletions();
        this.constraint = con;
        this.panel = new SimplePanel();
        this.model = modeller.getModel();
        this.modeller = modeller;
        this.fieldType = valueType = this.sce.getFieldType(pattern.factType, fieldName);
        this.numericValue = "Numeric".equals(valueType);
        this.readOnly = readOnly;
        this.dropDownData = "Boolean".equals(valueType) ? DropDownData.create((String[])new String[]{"true", "false"}) : this.sce.getEnums(pattern, fieldName);
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void refreshEditor() {
        this.panel.clear();
        Widget constraintWidget = null;
        if (this.constraint.constraintValueType == 0) {
            Image clickme = new Image("images/edit.gif");
            clickme.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            constraintWidget = clickme;
        } else {
            switch (this.constraint.constraintValueType) {
                case 1: {
                    if (this.dropDownData != null) {
                        constraintWidget = new EnumDropDownLabel(this.pattern, this.fieldName, this.sce, this.constraint);
                        ((EnumDropDownLabel)constraintWidget).setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                        break;
                    }
                    if ("Date".equals(this.fieldType)) {
                        DatePickerLabel datePicker = new DatePickerLabel(this.constraint.value);
                        this.constraint.value = datePicker.getDateString();
                        if (!this.readOnly) {
                            datePicker.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
                            constraintWidget = datePicker;
                            break;
                        }
                        constraintWidget = new SmallLabel(this.constraint.value);
                        break;
                    }
                    if (!this.readOnly) {
                        constraintWidget = new DefaultLiteralEditor(this.constraint, this.numericValue);
                        ((DefaultLiteralEditor)constraintWidget).setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                        break;
                    }
                    constraintWidget = new SmallLabel(this.constraint.value);
                    break;
                }
                case 3: {
                    constraintWidget = this.returnValueEditor();
                    break;
                }
                case 6: {
                    constraintWidget = this.expressionEditor();
                    break;
                }
                case 2: {
                    constraintWidget = this.variableEditor();
                    break;
                }
                case 7: {
                    constraintWidget = new DefaultLiteralEditor(this.constraint, false);
                    break;
                }
            }
        }
        this.panel.add(constraintWidget);
    }

    private Widget variableEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.constraint.value);
        }
        List vars = this.model.getBoundVariablesInScope(this.constraint);
        ListBox box = new ListBox();
        if (this.constraint.value == null) {
            box.addItem(this.constants.Choose());
        }
        int j = 0;
        for (int i = 0; i < vars.size(); ++i) {
            String var = (String)vars.get(i);
            FactPattern f = this.model.getBoundFact(var);
            String fv = this.model.getFieldConstraint(var);
            if (f != null && f.factType.equals(this.fieldType) || fv != null && fv.equals(this.fieldType)) {
                box.addItem(var);
                if (this.constraint.value != null && this.constraint.value.equals(var)) {
                    box.setSelectedIndex(j);
                }
                ++j;
                continue;
            }
            String factCollectionType = this.sce.getParametricFieldType(this.pattern.factType, this.fieldName);
            if ((f == null || factCollectionType == null || !f.factType.equals(factCollectionType)) && (factCollectionType == null || !factCollectionType.equals(fv))) continue;
            box.addItem(var);
            if (this.constraint.value != null && this.constraint.value.equals(var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget returnValueEditor() {
        BoundTextBox box = new BoundTextBox(this.constraint);
        String msg = this.constants.FormulaEvaluateToAValue();
        Image img = new Image("images/function_assets.gif");
        img.setTitle(msg);
        box.setTitle(msg);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Panel ed = this.widgets((Widget)img, (Widget)box);
        return ed;
    }

    private Widget expressionEditor() {
        if (!(this.constraint instanceof SingleFieldConstraint)) {
            throw new IllegalArgumentException("Expected SingleFieldConstraint, but " + this.constraint.getClass().getName() + " found.");
        }
        ExpressionBuilder builder = new ExpressionBuilder(this.modeller, ((SingleFieldConstraint)this.constraint).getExpression());
        builder.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        String msg = this.constants.ExpressionEditor();
        Panel ed = this.widgets((Widget)new HTML("&nbsp;"), (Widget)builder);
        return ed;
    }

    private void showTypeChoice(Widget w, ISingleFieldConstraint con) {
        FormStylePopup form = new FormStylePopup("images/newex_wiz.gif", this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(this.constants.LiteralValue(), this.constants.LiteralValTip())));
        if (this.modeller.isTemplate()) {
            String templateKeyLabel = this.constants.TemplateKey();
            Button templateKeyButton = new Button(templateKeyLabel);
            templateKeyButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(templateKeyLabel + ":", (Widget)this.widgets((Widget)templateKeyButton, (Widget)new InfoPopup(templateKeyLabel, this.constants.LiteralValTip())));
        }
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(this.constants.AdvancedOptions()));
        if (this.model.getBoundVariablesInScope(this.constraint).size() > 0 || "Collection".equals(this.fieldType)) {
            List vars = this.model.getBoundFacts();
            boolean foundABouncVariableThatMatches = false;
            for (int i = 0; i < vars.size(); ++i) {
                String var = (String)vars.get(i);
                FactPattern f = this.model.getBoundFact(var);
                String fieldConstraint = this.model.getFieldConstraint(var);
                if (f != null && f.factType.equals(this.fieldType) || this.fieldType.equals(fieldConstraint)) {
                    foundABouncVariableThatMatches = true;
                    break;
                }
                String factCollectionType = this.sce.getParametricFieldType(this.pattern.factType, this.fieldName);
                if ((f == null || factCollectionType == null || !f.factType.equals(factCollectionType)) && (factCollectionType == null || !factCollectionType.equals(fieldConstraint))) continue;
                foundABouncVariableThatMatches = true;
                break;
            }
            if (foundABouncVariableThatMatches) {
                Button variable = new Button(this.constants.BoundVariable());
                variable.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.ABoundVariable(), this.constants.BoundVariableTip())));
            }
        }
        Button formula = new Button(this.constants.NewFormula());
        formula.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.AFormula() + ":", (Widget)this.widgets((Widget)formula, (Widget)new InfoPopup(this.constants.AFormula(), this.constants.FormulaExpressionTip())));
        Button expression = new Button(this.constants.ExpressionEditor());
        expression.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.ExpressionEditor() + ":", (Widget)this.widgets((Widget)expression, (Widget)new InfoPopup(this.constants.ExpressionEditor(), this.constants.ExpressionEditor())));
        form.show();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.executeOnValueChangeCommand();
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    static /* synthetic */ ISingleFieldConstraint access$000(ConstraintValueEditor x0) {
        return x0.constraint;
    }

    static /* synthetic */ void access$100(ConstraintValueEditor x0, Widget x1, ISingleFieldConstraint x2) {
        x0.showTypeChoice(x1, x2);
    }

    static /* synthetic */ void access$200(ConstraintValueEditor x0) {
        x0.executeOnValueChangeCommand();
    }

    static /* synthetic */ void access$300(ConstraintValueEditor x0, FormStylePopup x1) {
        x0.doTypeChosen(x1);
    }
}

