/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollection;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollectionIndex;
import org.drools.ide.common.client.modeldriven.brl.ExpressionField;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFieldVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionGlobalVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionMethod;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVariable;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionBuilder
extends RuleModellerWidget {
    private static final String DELETE_VALUE = "_delete_";
    private static final String FIElD_VALUE_PREFIX = "fl";
    private static final String VARIABLE_VALUE_PREFIX = "va";
    private static final String GLOBAL_COLLECTION_VALUE_PREFIX = "gc";
    private static final String GLOBAL_VARIABLE_VALUE_PREFIX = "gv";
    private static final String METHOD_VALUE_PREFIX = "mt";
    private Constants constants = (Constants)GWT.create(Constants.class);
    private HorizontalPanel panel = new HorizontalPanel();
    private ExpressionFormLine expression;
    private boolean readOnly;

    public ExpressionBuilder(RuleModeller modeller, ExpressionFormLine expression) {
        this(modeller, expression, Boolean.valueOf(false));
    }

    public ExpressionBuilder(RuleModeller modeller, ExpressionFormLine expression, Boolean readOnly) {
        super(modeller);
        this.readOnly = readOnly == null ? !modeller.getSuggestionCompletions().containsFactType(modeller.getSuggestionCompletions().getFactNameFromType(this.expression.getRootExpression().getClassType())) : readOnly;
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.expression = expression;
        if (expression == null || expression.getText().length() == 0) {
            if (this.readOnly) {
                this.panel.add((Widget)new SmallLabel("<b>-</b>"));
            } else {
                this.panel.add(this.createStartPointWidget());
            }
        } else if (this.readOnly) {
            this.panel.add((Widget)new SmallLabel("<b>" + expression.getText() + "</b>"));
        } else {
            this.panel.add((Widget)new SmallLabel("<b>" + expression.getText() + ".</b>"));
            this.panel.add(this.getWidgetForCurrentType());
        }
        this.initWidget((Widget)this.panel);
    }

    private Widget createStartPointWidget() {
        ListBox startPoint = new ListBox();
        this.panel.add((Widget)startPoint);
        startPoint.addItem(this.constants.ChooseDotDotDot(), "");
        for (String gv : this.getCompletionEngine().getGlobalVariables()) {
            startPoint.addItem(gv, "gv." + gv);
        }
        for (String v : this.getRuleModel().getBoundFacts()) {
            startPoint.addItem(v, "va." + v);
        }
        startPoint.setVisibleItemCount(1);
        startPoint.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return startPoint;
    }

    private void startPointChange(String value) {
        this.setModified(true);
        this.panel.clear();
        int dotPos = value.indexOf(46);
        String prefix = value.substring(0, dotPos);
        String attrib = value.substring(dotPos + 1);
        if (prefix.equals(VARIABLE_VALUE_PREFIX)) {
            FactPattern fact = this.getRuleModel().getBoundFact(attrib);
            Object variable = fact != null ? new ExpressionVariable(fact) : new ExpressionFieldVariable(attrib);
            this.expression.appendPart((ExpressionPart)variable);
        } else if (prefix.equals(GLOBAL_VARIABLE_VALUE_PREFIX)) {
            String globalVarType = this.getCompletionEngine().getGlobalVariable(attrib);
            ExpressionGlobalVariable variable = new ExpressionGlobalVariable(attrib, globalVarType, globalVarType);
            this.expression.appendPart((ExpressionPart)variable);
        }
        Widget w = this.getWidgetForCurrentType();
        if (!this.expression.isEmpty()) {
            this.panel.add((Widget)new SmallLabel("<b>" + this.expression.getText() + ".</b>"));
        }
        if (w != null) {
            this.panel.add(w);
        }
    }

    private Widget getWidgetForCurrentType() {
        if (this.expression.isEmpty()) {
            return this.createStartPointWidget();
        }
        String factName = this.getCompletionEngine().getFactNameFromType(this.getCurrentClassType());
        if (factName != null) {
            ListBox lb = new ListBox();
            lb.setVisibleItemCount(1);
            lb.addItem(this.constants.ChooseDotDotDot(), "");
            lb.addItem("<==" + this.constants.DeleteItem(), DELETE_VALUE);
            for (Map.Entry entry : this.getCompletionsForCurrentType().entrySet()) {
                lb.addItem((String)entry.getKey(), (String)entry.getValue());
            }
            lb.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            return lb;
        }
        ListBox lb = new ListBox();
        lb.setVisibleItemCount(1);
        lb.addItem(this.constants.ChooseDotDotDot(), "");
        lb.addItem("<==" + this.constants.DeleteItem(), DELETE_VALUE);
        for (Map.Entry entry : this.getCompletionsForCurrentType().entrySet()) {
            lb.addItem((String)entry.getKey(), (String)entry.getValue());
        }
        lb.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return lb;
    }

    private void onCollectionChange(String value) {
        if ("size".contains(value)) {
            this.expression.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Numeric"));
        } else if ("isEmpty".equals(value)) {
            this.expression.appendPart((ExpressionPart)new ExpressionMethod("isEmpty", "boolean", "Boolean"));
        } else {
            String factName = this.getCompletionEngine().getFactNameFromType(this.getCurrentParametricType());
            ExpressionCollectionIndex collectionIndex = this.getCurrentParametricType() != null && factName != null ? new ExpressionCollectionIndex("get", this.getCurrentParametricType(), factName) : new ExpressionCollectionIndex("get", "java.lang.Object", "Object");
            if ("first".equals(value)) {
                collectionIndex.putParam("index", new ExpressionFormLine((ExpressionPart)new ExpressionText("0")));
                this.expression.appendPart((ExpressionPart)collectionIndex);
            } else if ("last".equals(value)) {
                ExpressionFormLine index = new ExpressionFormLine(this.expression);
                index.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Numeric"));
                index.appendPart((ExpressionPart)new ExpressionText("-1"));
                collectionIndex.putParam("index", index);
                this.expression.appendPart((ExpressionPart)collectionIndex);
            }
        }
    }

    private void onChangeSelection(String value) {
        this.setModified(true);
        String prevFactName = null;
        if (DELETE_VALUE.equals(value)) {
            this.expression.removeLast();
        } else if ("Collection".equals(this.getCurrentGenericType())) {
            this.onCollectionChange(value);
        } else if ("String".equals(this.getCurrentGenericType())) {
            if ("size".equals(value)) {
                this.expression.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Numeric"));
            } else if ("isEmpty".equals(value)) {
                this.expression.appendPart((ExpressionPart)new ExpressionText(".size() == 0", "", "Numeric"));
            }
        } else {
            int dotPos = value.indexOf(46);
            String prefix = value.substring(0, dotPos);
            String attrib = value.substring(dotPos + 1);
            prevFactName = this.getCompletionEngine().getFactNameFromType(this.getCurrentClassType());
            if (FIElD_VALUE_PREFIX.equals(prefix)) {
                String fieldClassName = this.getCompletionEngine().getFieldClassName(prevFactName, attrib);
                String fieldGenericType = this.getCompletionEngine().getFieldType(prevFactName, attrib);
                if ("Collection".equals(fieldGenericType)) {
                    String fieldParametricType = this.getCompletionEngine().getParametricFieldType(prevFactName, attrib);
                    this.expression.appendPart((ExpressionPart)new ExpressionCollection(attrib, fieldClassName, fieldGenericType, fieldParametricType));
                } else {
                    this.expression.appendPart((ExpressionPart)new ExpressionField(attrib, fieldClassName, fieldGenericType));
                }
            } else if (METHOD_VALUE_PREFIX.equals(prefix)) {
                MethodInfo mi = this.getCompletionEngine().getMethodinfo(prevFactName, attrib);
                if ("Collection".equals(mi.getGenericType())) {
                    this.expression.appendPart((ExpressionPart)new ExpressionCollection(attrib, mi.getReturnClassType(), mi.getGenericType(), mi.getParametricReturnType()));
                } else {
                    this.expression.appendPart((ExpressionPart)new ExpressionMethod(mi.getName(), mi.getReturnClassType(), mi.getGenericType()));
                }
            }
        }
        Widget w = this.getWidgetForCurrentType();
        this.panel.clear();
        if (!this.expression.isEmpty()) {
            this.panel.add((Widget)new SmallLabel("<b>" + this.expression.getText() + ".</b>"));
        }
        if (w != null) {
            this.panel.add(w);
        }
    }

    private Map<String, String> getCompletionsForCurrentType() {
        LinkedHashMap<String, String> completions = new LinkedHashMap<String, String>();
        if ("FinalObject".equals(this.getCurrentGenericType())) {
            return completions;
        }
        if ("Collection".equals(this.getCurrentGenericType())) {
            completions.put("size()", "size");
            completions.put("first()", "first");
            completions.put("last()", "last");
            completions.put("isEmpty()", "isEmpty");
            return completions;
        }
        if ("String".equals(this.getCurrentGenericType())) {
            completions.put("size()", "size");
            completions.put("isEmpty()", "isEmpty");
            return completions;
        }
        if ("Boolean".equals(this.getCurrentGenericType()) || "Numeric".equals(this.getCurrentGenericType()) || "Date".equals(this.getCurrentGenericType()) || "Object".equals(this.getCurrentGenericType())) {
            return completions;
        }
        String factName = this.getCompletionEngine().getFactNameFromType(this.getCurrentClassType());
        if (factName != null) {
            List methodNames = this.getCompletionEngine().getMethodFullNames(factName, 0);
            for (String field : this.getCompletionEngine().getFieldCompletions(factName)) {
                boolean changed = false;
                Iterator i = methodNames.iterator();
                while (i.hasNext()) {
                    String method = (String)i.next();
                    if (!method.startsWith(field)) continue;
                    completions.put(method, "mt." + method);
                    i.remove();
                    changed = true;
                }
                if (changed) continue;
                completions.put(field, "fl." + field);
            }
        }
        return completions;
    }

    private String getCurrentPartName() {
        return this.expression.getCurrentName();
    }

    private RuleModel getRuleModel() {
        return this.getModeller().getModel();
    }

    private SuggestionCompletionEngine getCompletionEngine() {
        return this.getModeller().getSuggestionCompletions();
    }

    private String getCurrentClassType() {
        return this.expression.getClassType();
    }

    private String getCurrentGenericType() {
        return this.expression.getGenericType();
    }

    private String getCurrentParametricType() {
        return this.expression.getParametricType();
    }

    private String getPreviousClassType() {
        return this.expression.getPreviousType();
    }

    private ExpressionPart getRootExpression() {
        return this.expression.getRootExpression();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    static /* synthetic */ void access$000(ExpressionBuilder x0, String x1) {
        x0.startPointChange(x1);
    }

    static /* synthetic */ HorizontalPanel access$100(ExpressionBuilder x0) {
        return x0.panel;
    }

    static /* synthetic */ void access$200(ExpressionBuilder x0, String x1) {
        x0.onChangeSelection(x1);
    }
}

