/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.modeldriven.ui.FactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.modeldriven.ui.factPattern.Connectives;
import org.drools.guvnor.client.modeldriven.ui.factPattern.PopupCreator;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactPatternWidget
extends RuleModellerWidget {
    private FactPattern pattern;
    private SuggestionCompletionEngine completions;
    private DirtyableFlexTable layout = new DirtyableFlexTable();
    private Connectives connectives;
    private PopupCreator popupCreator;
    private boolean bindable;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private String customLabel;
    private boolean readOnly;

    public FactPatternWidget(RuleModeller mod, IPattern p, boolean canBind) {
        this(mod, p, null, canBind, null);
    }

    public FactPatternWidget(RuleModeller mod, IPattern p, String customLabel, boolean canBind) {
        this(mod, p, null, canBind, null);
    }

    public FactPatternWidget(RuleModeller ruleModeller, IPattern pattern, boolean canBind, Boolean readOnly) {
        this(ruleModeller, pattern, null, canBind, readOnly);
    }

    public FactPatternWidget(RuleModeller mod, IPattern p, String customLabel, boolean canBind, Boolean readOnly) {
        super(mod);
        this.pattern = (FactPattern)p;
        this.completions = mod.getSuggestionCompletions();
        this.bindable = canBind;
        this.connectives = new Connectives();
        this.connectives.setCompletions(this.completions);
        this.connectives.setModeller(mod);
        this.connectives.setPattern(this.pattern);
        this.popupCreator = new PopupCreator();
        this.popupCreator.setBindable(this.bindable);
        this.popupCreator.setCompletions(this.completions);
        this.popupCreator.setModeller(mod);
        this.popupCreator.setPattern(this.pattern);
        this.customLabel = customLabel;
        this.readOnly = readOnly == null ? !this.completions.containsFactType(this.pattern.factType) : readOnly;
        this.layout.setWidget(0, 0, this.getPatternLabel());
        FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
        formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_BOTTOM);
        formatter.setStyleName(0, 0, "modeller-fact-TypeHeader");
        List sortedConst = this.sortConstraints(this.pattern.getFieldConstraints());
        this.pattern.setFieldConstraints(sortedConst);
        this.drawConstraints(sortedConst);
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        if (this.bindable) {
            this.layout.addStyleName("modeller-fact-pattern-Widget");
        }
        this.initWidget((Widget)this.layout);
    }

    private void drawConstraints(List<FieldConstraint> sortedConst) {
        DirtyableFlexTable table = new DirtyableFlexTable();
        this.layout.setWidget(1, 0, (Widget)table);
        ArrayList<FieldConstraint> parents = new ArrayList<FieldConstraint>();
        for (int i = 0; i < sortedConst.size(); ++i) {
            int tabs = -1;
            FieldConstraint current = sortedConst.get(i);
            if (current instanceof SingleFieldConstraint) {
                SingleFieldConstraint single = (SingleFieldConstraint)current;
                FieldConstraint parent = single.parent;
                for (int j = 0; j < parents.size(); ++j) {
                    FieldConstraint storedParent = (FieldConstraint)parents.get(j);
                    if (storedParent == null || !storedParent.equals(parent)) continue;
                    tabs = j + 1;
                    for (int k = j + 1; k < parents.size(); ++k) {
                        parents.remove(j + 1);
                    }
                    parents.add(current);
                    break;
                }
                if (tabs < 0) {
                    tabs = 0;
                    parents.add(current);
                }
            }
            this.renderFieldConstraint(table, i, current, true, tabs);
            int currentRow = i;
            ImageButton clear = new ImageButton("images/delete_faded.gif");
            clear.setTitle(this.constants.RemoveThisWholeRestriction());
            clear.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            if (this.readOnly) continue;
            table.setWidget(currentRow, 5, (Widget)clear);
        }
    }

    private List<FieldConstraint> sortConstraints(FieldConstraint[] constraints) {
        ArrayList<FieldConstraint> sortedConst = new ArrayList<FieldConstraint>(constraints.length);
        for (int i = 0; i < constraints.length; ++i) {
            FieldConstraint current = constraints[i];
            if (current instanceof SingleFieldConstraint) {
                SingleFieldConstraint single = (SingleFieldConstraint)current;
                int index = sortedConst.indexOf(single.parent);
                if (single.parent == null) {
                    sortedConst.add((FieldConstraint)single);
                    continue;
                }
                if (index >= 0) {
                    sortedConst.add(index + 1, (FieldConstraint)single);
                    continue;
                }
                this.insertSingleFieldConstraint(single, sortedConst);
                continue;
            }
            sortedConst.add(current);
        }
        return sortedConst;
    }

    private void insertSingleFieldConstraint(SingleFieldConstraint fieldConst, List<FieldConstraint> sortedConst) {
        if (fieldConst.parent instanceof SingleFieldConstraint) {
            this.insertSingleFieldConstraint((SingleFieldConstraint)fieldConst.parent, sortedConst);
        }
        sortedConst.add((FieldConstraint)fieldConst);
    }

    private void renderFieldConstraint(DirtyableFlexTable inner, int row, FieldConstraint constraint, boolean showBinding, int tabs) {
        if (constraint instanceof SingleFieldConstraint) {
            this.renderSingleFieldConstraint(this.getModeller(), inner, row, (SingleFieldConstraint)constraint, showBinding, tabs);
        } else if (constraint instanceof CompositeFieldConstraint) {
            inner.setWidget(row, 1, this.compositeFieldConstraintEditor((CompositeFieldConstraint)constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
            inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        }
    }

    private Widget compositeFieldConstraintEditor(CompositeFieldConstraint constraint) {
        FlexTable t = new FlexTable();
        String desc = null;
        2 click = new /* Unavailable Anonymous Inner Class!! */;
        desc = constraint.compositeJunctionType.equals("&&") ? this.constants.AllOf() + ":" : this.constants.AnyOf() + ":";
        t.setWidget(0, 0, (Widget)new ClickableLabel(desc, (ClickListener)click, !this.readOnly));
        t.getFlexCellFormatter().setColSpan(0, 0, 2);
        FieldConstraint[] nested = constraint.constraints;
        DirtyableFlexTable inner = new DirtyableFlexTable();
        inner.setStyleName("modeller-inner-nested-Constraints");
        if (nested != null) {
            for (int i = 0; i < nested.length; ++i) {
                this.renderFieldConstraint(inner, i, nested[i], false, 0);
                int currentRow = i;
                ImageButton clear = new ImageButton("images/delete_faded.gif");
                clear.setTitle(this.constants.RemoveThisNestedRestriction());
                clear.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                if (this.readOnly) continue;
                inner.setWidget(i, 5, (Widget)clear);
            }
        }
        t.setWidget(1, 1, (Widget)inner);
        t.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        return t;
    }

    private void renderSingleFieldConstraint(RuleModeller modeller, DirtyableFlexTable inner, int row, SingleFieldConstraint constraint, boolean showBinding, int tabs) {
        int col = 1;
        inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (constraint.constraintValueType != 5) {
            inner.setWidget(row, 0 + col, this.fieldLabel(constraint, showBinding, tabs * 20));
            inner.setWidget(row, 1 + col, this.operatorDropDown(constraint));
            inner.setWidget(row, 2 + col, this.valueEditor(constraint, constraint.fieldType));
            inner.setWidget(row, 3 + col, this.connectives.connectives(constraint, constraint.fieldType));
            ImageButton addConnective = new ImageButton("images/add_connective.gif");
            addConnective.setTitle(this.constants.AddMoreOptionsToThisFieldsValues());
            addConnective.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            if (!this.readOnly) {
                inner.setWidget(row, 4 + col, (Widget)addConnective);
            }
        } else if (constraint.constraintValueType == 5) {
            inner.setWidget(row, 1, this.predicateEditor(constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
        }
    }

    private Widget predicateEditor(SingleFieldConstraint c) {
        HorizontalPanel pred = new HorizontalPanel();
        pred.setWidth("100%");
        Image img = new Image("images/function_assets.gif");
        img.setTitle(this.constants.FormulaBooleanTip());
        pred.add((Widget)img);
        if (c.value == null) {
            c.value = "";
        }
        TextBox box = new TextBox();
        box.setText(c.value);
        if (!this.readOnly) {
            box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            box.setWidth("100%");
            pred.add((Widget)box);
        } else {
            pred.add((Widget)new SmallLabel(c.value));
        }
        return pred;
    }

    private Widget getPatternLabel() {
        6 click = new /* Unavailable Anonymous Inner Class!! */;
        String patternName = this.pattern.boundName != null ? this.pattern.factType + " <b>[" + this.pattern.boundName + "]</b>" : this.pattern.factType;
        String desc = this.getCustomLabel();
        if (desc == null) {
            desc = this.pattern.constraintList != null && this.pattern.constraintList.constraints.length > 0 ? Format.format((String)this.constants.ThereIsAAn0With(), (String)patternName) : Format.format((String)this.constants.ThereIsAAn0(), (String)patternName);
            desc = this.anA(desc, patternName);
        } else {
            desc = Format.format((String)desc, (String)patternName);
        }
        return new ClickableLabel(desc, (ClickListener)click, !this.readOnly);
    }

    private String anA(String desc, String patternName) {
        if (desc.startsWith("There is a/an")) {
            String vowel = patternName.substring(0, 1);
            if (vowel.equalsIgnoreCase("A") || vowel.equalsIgnoreCase("E") || vowel.equalsIgnoreCase("I") || vowel.equalsIgnoreCase("O") || vowel.equalsIgnoreCase("U")) {
                return desc.replace("There is a/an", "There is an");
            }
            return desc.replace("There is a/an", "There is a");
        }
        return desc;
    }

    private Widget valueEditor(SingleFieldConstraint c, String factType) {
        ConstraintValueEditor constraintValueEditor = new ConstraintValueEditor(this.pattern, c.fieldName, (ISingleFieldConstraint)c, this.getModeller(), c.fieldType, this.readOnly);
        constraintValueEditor.setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        return constraintValueEditor;
    }

    private Widget operatorDropDown(SingleFieldConstraint c) {
        if (!this.readOnly) {
            String[] ops = this.completions.getOperatorCompletions(this.pattern.factType, c.fieldName);
            ListBox box = new ListBox();
            box.addItem(this.constants.pleaseChoose(), "");
            for (int i = 0; i < ops.length; ++i) {
                String op = ops[i];
                box.addItem(HumanReadable.getOperatorDisplayName((String)op), op);
                if (!op.equals(c.operator)) continue;
                box.setSelectedIndex(i + 1);
            }
            box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            return box;
        }
        SmallLabel sl = new SmallLabel("<b>" + (c.operator == null ? this.constants.pleaseChoose() : HumanReadable.getOperatorDisplayName((String)c.operator)) + "</b>");
        return sl;
    }

    private Widget fieldLabel(SingleFieldConstraint con, boolean showBinding, int padding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        if (!con.isBound()) {
            if (this.bindable && showBinding && !this.readOnly) {
                9 click = new /* Unavailable Anonymous Inner Class!! */;
                ImageButton bind = new ImageButton("images/edit_tiny.gif", this.constants.GiveFieldVarName());
                bind.addClickListener((ClickListener)click);
                ClickableLabel cl = new ClickableLabel(con.fieldName, (ClickListener)click, !this.readOnly);
                DOM.setStyleAttribute((Element)cl.getElement(), (String)"marginLeft", (String)("" + padding + "pt"));
                ab.add((Widget)cl);
            } else {
                ab.add((Widget)new SmallLabel(con.fieldName));
            }
        } else {
            ab.add((Widget)new SmallLabel(con.fieldName));
            ab.add((Widget)new SmallLabel(" <b>[" + con.fieldBinding + "]</b>"));
        }
        return ab;
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public void setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    static /* synthetic */ Constants access$000(FactPatternWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ FactPattern access$100(FactPatternWidget x0) {
        return x0.pattern;
    }

    static /* synthetic */ PopupCreator access$200(FactPatternWidget x0) {
        return x0.popupCreator;
    }

    static /* synthetic */ SuggestionCompletionEngine access$300(FactPatternWidget x0) {
        return x0.completions;
    }
}

