/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.RuleViewer;

public abstract class AssetAttachmentFileWidget
extends Composite {
    private FormPanel form;
    private Button ok;
    private RuleViewer viewer;
    protected FormStyleLayout layout;
    protected RuleAsset asset;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public AssetAttachmentFileWidget(RuleAsset asset, RuleViewer viewer) {
        this.viewer = viewer;
        this.asset = asset;
        this.initWidgets(asset.uuid, asset.metaData.name);
        this.initAssetHandlers();
    }

    public AssetAttachmentFileWidget() {
    }

    protected void initWidgets(String uuid, String formName) {
        this.form = new FormPanel();
        this.form.setAction(GWT.getModuleBaseURL() + "asset");
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        FileUpload up = new FileUpload();
        up.setName("fileUploadElement");
        HorizontalPanel fields = new HorizontalPanel();
        fields.add((Widget)this.getHiddenField("attachmentUUID", uuid));
        this.ok = new Button(this.constants.Upload());
        fields.add((Widget)up);
        fields.add((Widget)this.ok);
        this.form.add((Widget)fields);
        this.layout = new FormStyleLayout(this.getIcon(), formName);
        if (!this.asset.isreadonly) {
            this.layout.addAttribute(this.constants.UploadNewVersion(), (Widget)this.form);
        }
        Button dl = new Button(this.constants.Download());
        dl.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.addAttribute(this.constants.DownloadCurrentVersion(), (Widget)dl);
        this.ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)this.layout);
        this.layout.setWidth("100%");
        this.setStyleName(this.getOverallStyleName());
    }

    public abstract String getIcon();

    public abstract String getOverallStyleName();

    void initAssetHandlers() {
        this.form.addFormHandler((FormHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void submitUpload() {
        this.form.submit();
    }

    protected void showUploadingBusy() {
        LoadingPopup.showMessage((String)this.constants.Uploading());
    }

    private TextBox getHiddenField(String name, String value) {
        TextBox t = new TextBox();
        t.setName(name);
        t.setText(value);
        t.setVisible(false);
        return t;
    }

    public void addDescription(Widget d) {
        this.layout.addRow(d);
    }

    static /* synthetic */ RuleViewer access$000(AssetAttachmentFileWidget x0) {
        return x0.viewer;
    }

    static /* synthetic */ Constants access$100(AssetAttachmentFileWidget x0) {
        return x0.constants;
    }
}

