/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import java.util.Iterator;
import org.drools.guvnor.client.packages.PackageHeaderWidget;

public class PackageHeaderHelper {
    static PackageHeaderWidget.Types parseHeader(String header) {
        if (header == null || header.equals("")) {
            PackageHeaderWidget.Types t = new PackageHeaderWidget.Types();
            return t;
        }
        PackageHeaderWidget.Types t = new PackageHeaderWidget.Types();
        String[] lines = header.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String tk = lines[i].trim();
            if (tk.equals("") || tk.startsWith("#")) continue;
            if (tk.startsWith("import")) {
                if ((tk = tk.substring(6).trim()).endsWith(";")) {
                    tk = tk.substring(0, tk.length() - 1);
                }
                t.imports.add(new PackageHeaderWidget.Import(tk));
                continue;
            }
            if (tk.startsWith("global")) {
                if ((tk = tk.substring(6).trim()).endsWith(";")) {
                    tk = tk.substring(0, tk.length() - 1);
                }
                String[] gt = tk.split("\\s+");
                t.globals.add(new PackageHeaderWidget.Global(gt[0], gt[1]));
                continue;
            }
            return null;
        }
        return t;
    }

    static String renderTypes(PackageHeaderWidget.Types t) {
        StringBuffer sb = new StringBuffer();
        for (PackageHeaderWidget.Import i : t.imports) {
            sb.append("import " + i.type + "\n");
        }
        Iterator it = t.globals.iterator();
        while (it.hasNext()) {
            PackageHeaderWidget.Global g = (PackageHeaderWidget.Global)it.next();
            sb.append("global " + g.type + " " + g.name);
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

