/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.QuickTipsConfig;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.ToolbarItem;
import com.gwtext.client.widgets.ToolbarMenuButton;
import com.gwtext.client.widgets.ToolbarTextItem;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.menu.BaseItem;
import com.gwtext.client.widgets.menu.Item;
import com.gwtext.client.widgets.menu.Menu;
import com.gwtext.client.widgets.menu.event.BaseItemListener;
import java.util.Set;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.explorer.ExplorerLayoutManager;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.RuleModelEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.packages.WorkingSetManager;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.CheckinPopup;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.guvnor.client.ruleeditor.WorkingSetSelectorPopup;
import org.drools.guvnor.client.security.Capabilities;

public class ActionToolbar
extends Composite {
    static String[] VALIDATING_FORMATS = new String[]{"brl", "dslr", "xls", "drl", "enumeration", "gdst", "model.drl", "dsl", "function", "template"};
    static String[] VERIFY_FORMATS = new String[]{"brl", "xls", "drl", "gdst", "model.drl", "template"};
    private Toolbar toolbar;
    private CheckinAction checkinAction;
    private Command archiveAction;
    private Command deleteAction;
    private ToolbarTextItem state;
    private final RuleAsset asset;
    private Command afterCheckinEvent;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private SmallLabel savedOK;
    private Widget editor;
    private Command closeCommand;
    private Command copyCommand;
    private Command promptCommand;

    public ActionToolbar(RuleAsset asset, boolean readOnly, Widget editor, CheckinAction checkin, Command archiv, Command delete, Command closeCommand, Command copyCommand, Command promptCommand) {
        this.checkinAction = checkin;
        this.archiveAction = archiv;
        this.deleteAction = delete;
        this.asset = asset;
        this.editor = editor;
        this.closeCommand = closeCommand;
        this.copyCommand = copyCommand;
        this.promptCommand = promptCommand;
        this.state = new ToolbarTextItem(this.constants.Status() + " ");
        this.toolbar = new Toolbar();
        String status = asset.metaData.status;
        this.setState(status);
        if (!readOnly && !asset.isreadonly) {
            this.controls();
        }
        this.toolbar.addItem((ToolbarItem)this.state);
        this.initWidget((Widget)this.toolbar);
    }

    public void showSavedConfirmation() {
        this.savedOK.setVisible(true);
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(1500);
    }

    private void setState(String status) {
        this.state.setText(Format.format((String)this.constants.statusIs(), (String)status));
    }

    private void controls() {
        ToolbarButton save = new ToolbarButton();
        save.setText(this.constants.SaveChanges());
        save.setTooltip(this.getTip(this.constants.CommitAnyChangesForThisAsset()));
        save.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.addButton(save);
        ToolbarButton saveAndClose = new ToolbarButton();
        saveAndClose.setText(this.constants.SaveAndClose());
        saveAndClose.setTooltip(this.getTip(this.constants.CommitAnyChangesForThisAsset()));
        saveAndClose.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.addButton(saveAndClose);
        this.savedOK = new SmallLabel("<font color='green'>" + this.constants.SavedOK() + "</font>");
        this.savedOK.setVisible(false);
        this.toolbar.addElement(this.savedOK.getElement());
        this.toolbar.addFill();
        this.toolbar.addSeparator();
        Menu moreMenu = new Menu();
        moreMenu.addItem((BaseItem)new Item(this.constants.Copy(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        moreMenu.addItem((BaseItem)new Item(this.constants.PromoteToGlobal(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        moreMenu.addItem((BaseItem)new Item(this.constants.Archive(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        Item deleteItem = new Item(this.constants.Delete(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */);
        moreMenu.addItem((BaseItem)deleteItem);
        deleteItem.setTitle(this.constants.DeleteAssetTooltip());
        this.afterCheckinEvent = new /* Unavailable Anonymous Inner Class!! */;
        if (!this.notCheckedInYet()) {
            deleteItem.setDisabled(true);
        }
        moreMenu.addItem((BaseItem)new Item(this.constants.ChangeStatus(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        ToolbarMenuButton more = new ToolbarMenuButton(this.constants.Actions(), moreMenu);
        if (this.isValidatorTypeAsset()) {
            if (this.editor instanceof RuleModelEditor) {
                ToolbarButton workingSets = new ToolbarButton();
                workingSets.setText(this.constants.SelectWorkingSets());
                workingSets.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
                this.toolbar.addButton(workingSets);
            }
            ToolbarButton validate = new ToolbarButton();
            validate.setText(this.constants.Validate());
            validate.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.addButton(validate);
            if (this.isVerificationTypeAsset()) {
                ToolbarButton verify = new ToolbarButton();
                verify.setText(this.constants.Verify());
                verify.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
                this.toolbar.addButton(verify);
            }
            if (this.shouldShowViewSource()) {
                ToolbarButton viewSource = new ToolbarButton();
                viewSource.setText(this.constants.ViewSource());
                viewSource.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
                this.toolbar.addButton(viewSource);
            }
        }
        this.toolbar.addButton(more);
    }

    private boolean shouldShowViewSource() {
        return ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_PACKAGE_VIEW});
    }

    private void doViewsource() {
        this.onSave();
        LoadingPopup.showMessage((String)this.constants.CalculatingSource());
        RepositoryServiceFactory.getService().buildAssetSource(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showSource(String src) {
        PackageBuilderWidget.showSource((String)src, (String)this.asset.metaData.name);
        LoadingPopup.close();
    }

    private void doVerify() {
        this.onSave();
        LoadingPopup.showMessage((String)this.constants.VerifyingItemPleaseWait());
        Set activeWorkingSets = null;
        activeWorkingSets = WorkingSetManager.getInstance().getActiveAssetUUIDs(this.asset.metaData.packageName);
        RepositoryServiceFactory.getService().verifyAsset(this.asset, activeWorkingSets, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doValidate() {
        this.onSave();
        LoadingPopup.showMessage((String)this.constants.ValidatingItemPleaseWait());
        RepositoryServiceFactory.getService().buildAsset(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave();
        }
    }

    private boolean isValidatorTypeAsset() {
        String format = this.asset.metaData.format;
        for (String fmt : VALIDATING_FORMATS) {
            if (!fmt.equals(format)) continue;
            return true;
        }
        return false;
    }

    private boolean isVerificationTypeAsset() {
        String format = this.asset.metaData.format;
        for (String fmt : VERIFY_FORMATS) {
            if (!fmt.equals(format)) continue;
            return true;
        }
        return false;
    }

    private boolean notCheckedInYet() {
        return this.asset.metaData.versionNumber == 0L;
    }

    private QuickTipsConfig getTip(String t) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void verifyAndDoCheckinConfirm(Widget w, boolean closeAfter) {
        if (this.editor instanceof RuleModeller) {
            ((RuleModeller)this.editor).verifyRule((Command)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.doCheckinConfirm(w, closeAfter);
        }
    }

    protected void doCheckinConfirm(Widget w, boolean closeAfter) {
        CheckinPopup pop = new CheckinPopup(w.getAbsoluteLeft(), w.getAbsoluteTop(), this.constants.CheckInChanges());
        pop.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void showStatusChanger() {
        StatusChangePopup pop = new StatusChangePopup(this.asset.uuid, false);
        pop.setChangeStatusEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showWorkingSetsSelection(RuleModeller modeller) {
        new WorkingSetSelectorPopup(modeller, this.asset).show();
    }

    static /* synthetic */ SmallLabel access$000(ActionToolbar x0) {
        return x0.savedOK;
    }

    static /* synthetic */ Command access$100(ActionToolbar x0) {
        return x0.copyCommand;
    }

    static /* synthetic */ Command access$200(ActionToolbar x0) {
        return x0.promptCommand;
    }

    static /* synthetic */ Constants access$300(ActionToolbar x0) {
        return x0.constants;
    }

    static /* synthetic */ Command access$400(ActionToolbar x0) {
        return x0.archiveAction;
    }

    static /* synthetic */ Command access$500(ActionToolbar x0) {
        return x0.deleteAction;
    }

    static /* synthetic */ void access$600(ActionToolbar x0) {
        x0.showStatusChanger();
    }

    static /* synthetic */ Widget access$700(ActionToolbar x0) {
        return x0.editor;
    }

    static /* synthetic */ void access$800(ActionToolbar x0) {
        x0.doValidate();
    }

    static /* synthetic */ void access$900(ActionToolbar x0) {
        x0.doVerify();
    }

    static /* synthetic */ void access$1000(ActionToolbar x0) {
        x0.doViewsource();
    }

    static /* synthetic */ void access$1100(ActionToolbar x0, String x1) {
        x0.showSource(x1);
    }

    static /* synthetic */ CheckinAction access$1200(ActionToolbar x0) {
        return x0.checkinAction;
    }

    static /* synthetic */ Command access$1300(ActionToolbar x0) {
        return x0.afterCheckinEvent;
    }

    static /* synthetic */ Command access$1400(ActionToolbar x0) {
        return x0.closeCommand;
    }

    static /* synthetic */ void access$1500(ActionToolbar x0, String x1) {
        x0.setState(x1);
    }
}

