/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.EditorLauncher;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.RuleDocumentWidget;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.rulelist.EditItemEvent;

public class RuleViewer
extends GuvnorEditor {
    private Command closeCommand;
    private Command archiveCommand;
    public Command checkedInCommand;
    public ActionToolbar.CheckinAction checkInCommand;
    protected RuleAsset asset;
    private boolean readOnly;
    private boolean metaVisible = true;
    private boolean docoVisible = true;
    private MetaDataWidget metaWidget;
    private RuleDocumentWidget doco;
    private Widget editor;
    private ActionToolbar toolbar;
    private VerticalPanel layout;
    private HorizontalPanel hsp;
    private long lastSaved = System.currentTimeMillis();
    private Constants constants = (Constants)GWT.create(Constants.class);
    private final EditItemEvent editEvent;

    public RuleViewer(RuleAsset asset, EditItemEvent event) {
        this(asset, event, false);
    }

    public void setDocoVisible(boolean docoVisible) {
        this.docoVisible = docoVisible;
        this.doco.setVisible(docoVisible);
    }

    public void setMetaVisible(boolean metaVisible) {
        this.metaVisible = metaVisible;
        this.metaWidget.setVisible(metaVisible);
    }

    public RuleViewer(RuleAsset asset, EditItemEvent event, boolean historicalReadOnly) {
        this.editEvent = event;
        this.asset = asset;
        this.readOnly = historicalReadOnly && asset.isreadonly;
        this.layout = new VerticalPanel();
        this.layout.setWidth("100%");
        this.layout.setHeight("100%");
        this.checkInCommand = new /* Unavailable Anonymous Inner Class!! */;
        this.initWidget((Widget)this.layout);
        this.doWidgets(null);
        LoadingPopup.close();
    }

    public boolean isDirty() {
        return System.currentTimeMillis() - this.lastSaved > 3600000L;
    }

    private void doWidgets(Widget messageWidget) {
        this.layout.clear();
        this.editor = EditorLauncher.getEditorViewer((RuleAsset)this.asset, (RuleViewer)this);
        this.toolbar = new ActionToolbar(this.asset, this.readOnly, this.editor, this.checkInCommand, (Command)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.add((Widget)this.toolbar);
        this.layout.setCellHeight((Widget)this.toolbar, "30px");
        this.layout.setCellHorizontalAlignment((Widget)this.toolbar, HasHorizontalAlignment.ALIGN_LEFT);
        this.layout.setCellWidth((Widget)this.toolbar, "100%");
        if (messageWidget != null) {
            this.layout.add(messageWidget);
        }
        this.doMetaWidget();
        this.hsp = new HorizontalPanel();
        this.layout.add((Widget)this.hsp);
        this.doco = new RuleDocumentWidget(this.asset);
        this.doco.setVisible(this.docoVisible);
        VerticalPanel vert = new VerticalPanel();
        vert.add(this.editor);
        this.editor.setHeight("100%");
        vert.setWidth("100%");
        vert.setHeight("100%");
        this.hsp.add((Widget)vert);
        this.hsp.add((Widget)this.metaWidget);
        this.hsp.setCellWidth((Widget)this.metaWidget, "25%");
        this.hsp.setHeight("100%");
        this.layout.add((Widget)this.doco);
    }

    private void doMetaWidget() {
        this.metaWidget = new MetaDataWidget(this.asset.metaData, this.readOnly, this.asset.uuid, (Command)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */);
        this.metaWidget.setVisible(this.metaVisible);
    }

    protected boolean hasDirty() {
        return false;
    }

    private void close() {
        this.closeCommand.execute();
    }

    void doDelete() {
        this.readOnly = true;
        RepositoryServiceFactory.getService().deleteUncheckedRule(this.asset.uuid, this.asset.metaData.packageName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doArchive() {
        RepositoryServiceFactory.getService().archiveAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void performCheckIn(String comment) {
        this.asset.metaData.checkinComment = comment;
        boolean[] saved = new boolean[]{false};
        11 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(500);
        RepositoryServiceFactory.getService().checkinVersion(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void flushSuggestionCompletionCache() {
        if (AssetFormats.isPackageDependency((String)this.asset.metaData.format)) {
            LoadingPopup.showMessage((String)this.constants.RefreshingContentAssistance());
            SuggestionCompletionCache.getInstance().refreshPackage(this.asset.metaData.packageName, (Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void refreshDataAndView() {
        this.refreshDataAndView(null);
    }

    public void refreshDataAndView(Widget messageWidget) {
        LoadingPopup.showMessage((String)this.constants.RefreshingItem());
        RepositoryServiceFactory.getService().loadRuleAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshMetaWidgetOnly() {
        this.refreshMetaWidgetOnly(true);
    }

    private void refreshMetaWidgetOnly(boolean showBusy) {
        if (showBusy) {
            LoadingPopup.showMessage((String)this.constants.RefreshingItem());
        }
        RepositoryServiceFactory.getService().loadRuleAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCloseCommand(Command c) {
        this.closeCommand = c;
    }

    public void setCheckedInCommand(Command c) {
        this.checkedInCommand = c;
    }

    public void setArchiveCommand(Command c) {
        this.archiveCommand = c;
    }

    protected void doCloseUnsavedWarning() {
        FormStylePopup pop = new FormStylePopup("images/warning-large.png", this.constants.WARNINGUnCommittedChanges());
        Button dis = new Button(this.constants.Discard());
        Button can = new Button(this.constants.Cancel());
        HorizontalPanel hor = new HorizontalPanel();
        hor.add((Widget)dis);
        hor.add((Widget)can);
        pop.addRow((Widget)new HTML(this.constants.AreYouSureYouWantToDiscardChanges()));
        pop.addRow((Widget)hor);
        dis.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        can.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doCopy() {
        FormStylePopup form = new FormStylePopup("images/rule_asset.gif", this.constants.CopyThisItem());
        TextBox newName = new TextBox();
        form.addAttribute(this.constants.NewName(), (Widget)newName);
        RulePackageSelector sel = new RulePackageSelector();
        form.addAttribute(this.constants.NewPackage(), (Widget)sel);
        Button ok = new Button(this.constants.CreateCopy());
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute("", (Widget)ok);
        form.show();
    }

    private void completedCopying(String name, String pkg, String newAssetUUID) {
        Window.alert((String)Format.format((String)this.constants.CreatedANewItemSuccess(), (String)name, (String)pkg));
        if (this.editEvent != null) {
            this.editEvent.open(newAssetUUID);
        }
    }

    private void doPromptToGlobal() {
        if (this.asset.metaData.packageName.equals("globalArea")) {
            Window.alert((String)this.constants.ItemAlreadyInGlobalArea());
            return;
        }
        if (Window.confirm((String)this.constants.PromoteAreYouSure())) {
            RepositoryServiceFactory.getService().promoteAssetToGlobalArea(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ Widget access$000(RuleViewer x0) {
        return x0.editor;
    }

    static /* synthetic */ void access$100(RuleViewer x0, String x1) {
        x0.performCheckIn(x1);
    }

    static /* synthetic */ long access$202(RuleViewer x0, long x1) {
        x0.lastSaved = x1;
        return x0.lastSaved;
    }

    static /* synthetic */ void access$300(RuleViewer x0) {
        x0.doArchive();
    }

    static /* synthetic */ void access$400(RuleViewer x0) {
        x0.close();
    }

    static /* synthetic */ void access$500(RuleViewer x0) {
        x0.doCopy();
    }

    static /* synthetic */ void access$600(RuleViewer x0) {
        x0.doPromptToGlobal();
    }

    static /* synthetic */ Command access$700(RuleViewer x0) {
        return x0.archiveCommand;
    }

    static /* synthetic */ Constants access$800(RuleViewer x0) {
        return x0.constants;
    }

    static /* synthetic */ RuleDocumentWidget access$900(RuleViewer x0) {
        return x0.doco;
    }

    static /* synthetic */ void access$1000(RuleViewer x0, boolean x1) {
        x0.refreshMetaWidgetOnly(x1);
    }

    static /* synthetic */ ActionToolbar access$1100(RuleViewer x0) {
        return x0.toolbar;
    }

    static /* synthetic */ void access$1200(RuleViewer x0, Widget x1) {
        x0.doWidgets(x1);
    }

    static /* synthetic */ MetaDataWidget access$1300(RuleViewer x0) {
        return x0.metaWidget;
    }

    static /* synthetic */ HorizontalPanel access$1400(RuleViewer x0) {
        return x0.hsp;
    }

    static /* synthetic */ void access$1500(RuleViewer x0) {
        x0.doMetaWidget();
    }

    static /* synthetic */ Command access$1600(RuleViewer x0) {
        return x0.closeCommand;
    }

    static /* synthetic */ void access$1700(RuleViewer x0, String x1, String x2, String x3) {
        x0.completedCopying(x1, x2, x3);
    }
}

