/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.event.PanelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.client.helper.ConstraintsContainer;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.guvnor.client.ruleeditor.ConstraintEditor;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;

public class WorkingSetEditor
extends Composite {
    private static int idGenerator = 0;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private RuleAsset workingSet;
    private ListBox availFacts = new ListBox(true);
    private ListBox validFacts = new ListBox(true);
    private ListBox factsCombo = new ListBox(false);
    private boolean validFactsChanged = true;
    private SuggestionCompletionEngine sce;
    private ConstraintsContainer cc;
    private ListBox fieldsCombo = new ListBox(false);
    private ListBox constraintsCombo = new ListBox(false);
    private VerticalPanel vpConstraintConf = new VerticalPanel();
    private Map<String, ConstraintConfiguration> contraintsMap = new HashMap();

    public WorkingSetEditor(RuleAsset asset) {
        if (!"workingset".equals(asset.metaData.format)) {
            throw new IllegalArgumentException("asset must a be a workingset not a: " + asset.metaData.format);
        }
        this.workingSet = asset;
        this.sce = SuggestionCompletionCache.getInstance().getEngineFromCache(asset.metaData.packageName);
        WorkingSetConfigData wsData = (WorkingSetConfigData)this.workingSet.content;
        this.cc = new ConstraintsContainer((Collection)wsData.constraints);
        this.refreshWidgets();
        this.setWidth("100%");
    }

    private void refreshWidgets() {
        WorkingSetConfigData wsData = (WorkingSetConfigData)this.workingSet.content;
        TabPanel tPanel = new TabPanel();
        tPanel.setWidth(800);
        Panel pnl = new Panel();
        pnl.setClosable(false);
        pnl.setTitle("WS Definition");
        pnl.add((Widget)this.buildDoubleList(wsData));
        tPanel.add((Component)pnl);
        pnl = new Panel();
        pnl.setClosable(false);
        pnl.setTitle("WS Constraints");
        pnl.add(this.buildFactsConstraintsEditor(tPanel));
        tPanel.add((Component)pnl);
        tPanel.setActiveTab(0);
        this.initWidget((Widget)tPanel);
    }

    private Widget buildFactsConstraintsEditor(TabPanel tPanel) {
        this.factsCombo.setVisibleItemCount(1);
        this.fieldsCombo.setVisibleItemCount(1);
        this.constraintsCombo.setVisibleItemCount(5);
        tPanel.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.factsCombo.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldsCombo.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageButton addNewConstraint = new ImageButton("images/new_item.gif");
        addNewConstraint.setTitle(this.constants.AddNewConstraint());
        addNewConstraint.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Image removeConstraint = new Image("images/trash.gif");
        removeConstraint.setTitle(this.constants.removeConstraint());
        removeConstraint.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        FlexTable table = new FlexTable();
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(this.constants.FactTypes()));
        vp.add((Widget)this.factsCombo);
        table.setWidget(0, 0, (Widget)vp);
        vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(this.constants.Field()));
        vp.add((Widget)this.fieldsCombo);
        table.setWidget(1, 0, (Widget)vp);
        vp = new VerticalPanel();
        HorizontalPanel hp = new HorizontalPanel();
        vp.add((Widget)new SmallLabel("Constraints"));
        hp.add((Widget)this.constraintsCombo);
        VerticalPanel btnPanel = new VerticalPanel();
        btnPanel.add((Widget)addNewConstraint);
        btnPanel.add((Widget)removeConstraint);
        hp.add((Widget)btnPanel);
        vp.add((Widget)hp);
        table.setWidget(2, 0, (Widget)vp);
        table.getFlexCellFormatter().setRowSpan(2, 0, 3);
        this.constraintsCombo.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.vpConstraintConf.add((Widget)new SmallLabel("Contraints Parameters"));
        this.vpConstraintConf.add((Widget)new SmallLabel(""));
        table.setWidget(0, 1, (Widget)this.vpConstraintConf);
        table.getFlexCellFormatter().setRowSpan(0, 1, 5);
        this.fillSelectedFacts();
        this.fillSelectedFactFields();
        this.fillFieldConstrains();
        this.showConstraintConfig();
        return table;
    }

    protected void removeConstraint() {
        if (this.constraintsCombo.getSelectedIndex() != -1) {
            ConstraintConfiguration c = (ConstraintConfiguration)this.contraintsMap.get(this.constraintsCombo.getValue(this.constraintsCombo.getSelectedIndex()));
            ((WorkingSetConfigData)this.workingSet.content).constraints = this.getConstraintsConstrainer().removeConstraint(c);
        }
        this.fillFieldConstrains();
    }

    private void showConstraintConfig() {
        if (this.constraintsCombo.getItemCount() == 0) {
            this.vpConstraintConf.remove(this.vpConstraintConf.getWidgetCount() - 1);
            this.vpConstraintConf.add((Widget)new SmallLabel());
            return;
        }
        if (this.constraintsCombo.getSelectedIndex() != -1) {
            ConstraintConfiguration c = (ConstraintConfiguration)this.contraintsMap.get(this.constraintsCombo.getValue(this.constraintsCombo.getSelectedIndex()));
            ConstraintEditor editor = new ConstraintEditor(c);
            this.vpConstraintConf.remove(this.vpConstraintConf.getWidgetCount() - 1);
            this.vpConstraintConf.add((Widget)editor);
        }
    }

    private void showNewConstrainPop() {
        FormStylePopup pop = new FormStylePopup("images/config.png", this.constants.AddNewConstraint());
        Button addbutton = new Button(this.constants.OK());
        ListBox consDefsCombo = new ListBox(false);
        consDefsCombo.setVisibleItemCount(5);
        addbutton.setTitle(this.constants.AddNewConstraint());
        ArrayList names = new ArrayList(ConstraintsContainer.getAllConfigurations().keySet());
        Collections.sort(names);
        for (String name : names) {
            consDefsCombo.addItem(name);
        }
        addbutton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(this.constants.WillExtendTheFollowingRuleCalled(), (Widget)consDefsCombo);
        pop.addAttribute("", (Widget)addbutton);
        pop.show();
    }

    private void fillSelectedFacts() {
        if (this.validFactsChanged) {
            String s = this.factsCombo.getSelectedIndex() != -1 ? this.factsCombo.getItemText(this.factsCombo.getSelectedIndex()) : "";
            this.factsCombo.clear();
            this.validFactsChanged = false;
            for (int i = 0; i < this.validFacts.getItemCount(); ++i) {
                String itemText = this.validFacts.getItemText(i);
                this.factsCombo.addItem(itemText);
                if (!s.equals(itemText)) continue;
                this.factsCombo.setSelectedIndex(i);
            }
            if (this.factsCombo.getSelectedIndex() == -1 && this.factsCombo.getItemCount() > 0) {
                this.factsCombo.setSelectedIndex(0);
            }
            this.fillSelectedFactFields();
        }
    }

    private void fillSelectedFactFields() {
        if (this.factsCombo.getSelectedIndex() != -1) {
            String fact = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.fieldsCombo.clear();
            for (String field : this.getCompletionEngine().getFieldCompletions(fact)) {
                this.fieldsCombo.addItem(field);
            }
        }
        if (this.fieldsCombo.getSelectedIndex() == -1 && this.fieldsCombo.getItemCount() > 0) {
            this.fieldsCombo.setSelectedIndex(0);
        }
        this.fillFieldConstrains();
    }

    private void fillFieldConstrains() {
        if (this.fieldsCombo.getSelectedIndex() != -1) {
            String fieldName = this.fieldsCombo.getItemText(this.fieldsCombo.getSelectedIndex());
            String factField = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.constraintsCombo.clear();
            this.contraintsMap.clear();
            for (ConstraintConfiguration c : this.getConstraintsConstrainer().getConstraints(factField, fieldName)) {
                this.constraintsCombo.addItem(c.getConstraintName(), this.addContrainsMap(c));
            }
            this.vpConstraintConf.remove(this.vpConstraintConf.getWidgetCount() - 1);
            this.vpConstraintConf.add((Widget)new SmallLabel());
        }
        this.showConstraintConfig();
    }

    private synchronized String addContrainsMap(ConstraintConfiguration c) {
        String id = String.valueOf(idGenerator++);
        this.contraintsMap.put(id, c);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grid buildDoubleList(WorkingSetConfigData wsData) {
        Grid grid = new Grid(2, 3);
        SuggestionCompletionEngine sce = SuggestionCompletionCache.getInstance().getEngineFromCache(this.workingSet.metaData.packageName);
        boolean filteringFact = sce.isFilteringFacts();
        sce.setFilteringFacts(false);
        try {
            HashSet<String> elem = new HashSet<String>();
            this.availFacts.setVisibleItemCount(10);
            this.validFacts.setVisibleItemCount(10);
            if (wsData.validFacts != null) {
                elem.addAll(Arrays.asList(wsData.validFacts));
                for (String factName : wsData.validFacts) {
                    this.validFacts.addItem(factName);
                }
            }
            for (String factName : sce.getFactTypes()) {
                if (elem.contains(factName)) continue;
                this.availFacts.addItem(factName);
            }
            Grid btnsPanel = new Grid(2, 1);
            btnsPanel.setWidget(0, 0, (Widget)new Button(">", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            btnsPanel.setWidget(1, 0, (Widget)new Button("&lt;", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            grid.setWidget(0, 0, (Widget)new SmallLabel("Available Facts"));
            grid.setWidget(0, 1, (Widget)new SmallLabel(""));
            grid.setWidget(0, 2, (Widget)new SmallLabel("WorkingSet Facts"));
            grid.setWidget(1, 0, (Widget)this.availFacts);
            grid.setWidget(1, 1, (Widget)btnsPanel);
            grid.setWidget(1, 2, (Widget)this.validFacts);
            grid.getColumnFormatter().setWidth(0, "45%");
            grid.getColumnFormatter().setWidth(0, "10%");
            grid.getColumnFormatter().setWidth(0, "45%");
            Grid grid2 = grid;
            return grid2;
        }
        finally {
            sce.setFilteringFacts(filteringFact);
        }
    }

    private void updateAsset(ListBox availFacts) {
        ArrayList<String> l = new ArrayList<String>(availFacts.getItemCount());
        for (int i = 0; i < availFacts.getItemCount(); ++i) {
            l.add(availFacts.getItemText(i));
        }
        ((WorkingSetConfigData)this.workingSet.content).validFacts = l.toArray(new String[l.size()]);
    }

    private void copySelected(ListBox from, ListBox to) {
        int selected;
        while ((selected = from.getSelectedIndex()) != -1) {
            to.addItem(from.getItemText(selected));
            from.removeItem(selected);
            this.validFactsChanged = true;
        }
    }

    public SuggestionCompletionEngine getCompletionEngine() {
        return this.sce;
    }

    public ConstraintsContainer getConstraintsConstrainer() {
        return this.cc;
    }

    static /* synthetic */ void access$000(WorkingSetEditor x0) {
        x0.fillSelectedFacts();
    }

    static /* synthetic */ void access$100(WorkingSetEditor x0) {
        x0.fillSelectedFactFields();
    }

    static /* synthetic */ void access$200(WorkingSetEditor x0) {
        x0.fillFieldConstrains();
    }

    static /* synthetic */ void access$300(WorkingSetEditor x0) {
        x0.showNewConstrainPop();
    }

    static /* synthetic */ void access$400(WorkingSetEditor x0) {
        x0.showConstraintConfig();
    }

    static /* synthetic */ ListBox access$500(WorkingSetEditor x0) {
        return x0.factsCombo;
    }

    static /* synthetic */ ListBox access$600(WorkingSetEditor x0) {
        return x0.fieldsCombo;
    }

    static /* synthetic */ RuleAsset access$700(WorkingSetEditor x0) {
        return x0.workingSet;
    }

    static /* synthetic */ String access$800(WorkingSetEditor x0, ConstraintConfiguration x1) {
        return x0.addContrainsMap(x1);
    }

    static /* synthetic */ ListBox access$900(WorkingSetEditor x0) {
        return x0.constraintsCombo;
    }

    static /* synthetic */ ListBox access$1000(WorkingSetEditor x0) {
        return x0.availFacts;
    }

    static /* synthetic */ ListBox access$1100(WorkingSetEditor x0) {
        return x0.validFacts;
    }

    static /* synthetic */ void access$1200(WorkingSetEditor x0, ListBox x1, ListBox x2) {
        x0.copySelected(x1, x2);
    }

    static /* synthetic */ void access$1300(WorkingSetEditor x0, ListBox x1) {
        x0.updateAsset(x1);
    }
}

