/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializableException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXStreamContentHandler<T extends PortableObject>
extends ContentHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());

    protected XStream getXStream() {
        return xt;
    }

    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializableException {
        if (item.getContent() != null && item.getContent().length() > 0) {
            try {
                asset.content = (PortableObject)this.getXStream().fromXML(item.getContent());
            }
            catch (RulesRepositoryException e) {
                this.log.error("error marshalling asset content: " + asset.metaData.name, (Throwable)e);
                throw new SerializableException(e.getMessage());
            }
        } else {
            asset.content = new WorkingSetConfigData();
        }
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializableException {
        try {
            repoAsset.updateContent(this.getXStream().toXML((Object)asset.content));
        }
        catch (Exception e) {
            this.log.error("error marshalling asset content: " + asset.metaData.name, (Throwable)e);
            throw new SerializableException(e.getMessage());
        }
    }
}

