/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializableException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ModelContentHandler
extends ContentHandler
implements ICanHasAttachment {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializableException {
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializableException {
    }

    public void onAttachmentAdded(AssetItem asset) throws IOException {
        PackageItem pkg = asset.getPackage();
        StringBuilder header = this.createNewHeader(ServiceImplementation.getDroolsHeader((PackageItem)pkg));
        Set imports = this.getImportsFromJar(asset.getBinaryContentAttachment());
        for (String importLine : imports) {
            Pattern pattern = Pattern.compile("\\b" + importLine.replace(".", "\\.") + "\\b");
            if (pattern.matcher(header).find()) continue;
            header.append(importLine).append("\n");
        }
        ServiceImplementation.updateDroolsHeader((String)header.toString(), (PackageItem)pkg);
        pkg.checkin("Imports setup automatically on model import.");
    }

    public void onAttachmentRemoved(AssetItem item) throws IOException {
        PackageItem pkg = item.getPackage();
        StringBuilder header = this.createNewHeader(ServiceImplementation.getDroolsHeader((PackageItem)pkg));
        Set imports = this.getImportsFromJar(item.getBinaryContentAttachment());
        for (String importLine : imports) {
            String importLineWithLineEnd = importLine + "\n";
            header = this.removeImportIfItExists(header, importLineWithLineEnd);
        }
        ServiceImplementation.updateDroolsHeader((String)header.toString(), (PackageItem)pkg);
        pkg.checkin("Imports removed automatically on model archiving.");
    }

    private StringBuilder removeImportIfItExists(StringBuilder header, String importLine) {
        if (header.indexOf(importLine) >= 0) {
            int indexOfImportLine = header.indexOf(importLine);
            header = header.replace(indexOfImportLine, indexOfImportLine + importLine.length(), "");
        }
        return header;
    }

    private StringBuilder createNewHeader(String header) {
        StringBuilder buf = new StringBuilder();
        if (header != null) {
            buf.append(header);
            buf.append('\n');
        }
        return buf;
    }

    private Set<String> getImportsFromJar(InputStream in) throws IOException {
        HashSet<String> imports = new HashSet<String>();
        JarInputStream jis = new JarInputStream(in);
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().indexOf(36) != -1 || entry.getName().endsWith("package-info.class")) continue;
            String line = "import " + ModelContentHandler.convertPathToName((String)entry.getName());
            imports.add(line);
        }
        return imports;
    }

    public static String convertPathToName(String name) {
        return name.replace(".class", "").replace("/", ".");
    }
}

