/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.UserInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInbox {
    static final int MAX_RECENT_EDITED = 200;
    private static final String INBOX = "inbox";
    private UserInfo userInfo;

    public UserInbox(RulesRepository repo, String userName) {
        this.userInfo = new UserInfo(repo, userName);
    }

    public UserInbox(RulesRepository repo) {
        this.userInfo = new UserInfo(repo);
    }

    public void addToRecentEdited(String assetId, String note) {
        this.addToInbox("recentEdited", assetId, note, "self");
    }

    public void addToRecentOpened(String assetId, String note) {
        this.addToInbox("recentViewed", assetId, note, "self");
    }

    public void addToIncoming(String assetId, String note, String userFrom) {
        this.addToInbox("incoming", assetId, note, userFrom);
    }

    private void addToInbox(String boxName, String assetId, String note, String userFrom) {
        assert (boxName.equals("recentEdited") || boxName.equals("recentViewed") || boxName.equals("incoming"));
        List entries = this.removeAnyExisting(assetId, this.userInfo.readEntries(INBOX, boxName));
        if (entries.size() >= 200) {
            entries.remove(0);
            entries.add(new UserInfo.InboxEntry(assetId, note, userFrom));
        } else {
            entries.add(new UserInfo.InboxEntry(assetId, note, userFrom));
        }
        this.userInfo.writeEntries(INBOX, boxName, entries);
    }

    private List<UserInfo.InboxEntry> removeAnyExisting(String assetId, List<UserInfo.InboxEntry> inboxEntries) {
        Iterator<UserInfo.InboxEntry> it = inboxEntries.iterator();
        while (it.hasNext()) {
            UserInfo.InboxEntry e = it.next();
            if (!e.assetUUID.equals(assetId)) continue;
            it.remove();
            return inboxEntries;
        }
        return inboxEntries;
    }

    public List<UserInfo.InboxEntry> loadRecentEdited() {
        return this.userInfo.readEntries(INBOX, "recentEdited");
    }

    public List<UserInfo.InboxEntry> loadRecentOpened() {
        return this.userInfo.readEntries(INBOX, "recentViewed");
    }

    public List<UserInfo.InboxEntry> loadIncoming() {
        return this.userInfo.readEntries(INBOX, "incoming");
    }

    public void clearAll() {
        this.userInfo.clear(INBOX, "recentEdited");
        this.userInfo.clear(INBOX, "recentViewed");
        this.userInfo.clear(INBOX, "incoming");
    }

    public void clearIncoming() {
        this.userInfo.clear(INBOX, "incoming");
    }

    public static TableDataResult toTable(List<UserInfo.InboxEntry> entries, boolean showFrom) {
        TableDataResult res = new TableDataResult();
        res.currentPosition = 0L;
        res.total = entries.size();
        res.hasNext = false;
        res.data = new TableDataRow[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            TableDataRow tdr = new TableDataRow();
            UserInfo.InboxEntry e = entries.get(i);
            tdr.id = e.assetUUID;
            if (!showFrom) {
                tdr.values = new String[2];
                tdr.values[0] = e.note;
                tdr.values[1] = Long.toString(e.timestamp);
            } else {
                tdr.values = new String[3];
                tdr.values[0] = e.note;
                tdr.values[1] = Long.toString(e.timestamp);
                tdr.values[2] = e.from;
            }
            tdr.format = "brl";
            res.data[i] = tdr;
        }
        return res;
    }

    public static void recordOpeningEvent(AssetItem item) {
        UserInbox ib = new UserInbox(item.getRulesRepository());
        ib.addToRecentOpened(item.getUUID(), item.getName());
        List unreadIncoming = ib.removeAnyExisting(item.getUUID(), ib.loadIncoming());
        ib.userInfo.writeEntries(INBOX, "incoming", unreadIncoming);
        ib.save();
    }

    public static void recordUserEditEvent(AssetItem item) {
        UserInbox ib = new UserInbox(item.getRulesRepository());
        ib.addToRecentEdited(item.getUUID(), item.getName());
        ib.save();
    }

    void save() {
        this.userInfo.save();
    }
}

