/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListener;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import org.drools.guvnor.client.common.FormStyleLayout;

public class FormStylePopup {
    private FormStyleLayout form;
    private Window dialog;
    private String title;
    private Boolean shadow;
    private Integer width;
    private Integer height;
    private boolean modal = true;
    private int popLeft = -1;
    private int popTop;
    private Command afterShowEvent;

    public FormStylePopup(String image, String title) {
        this.form = new FormStyleLayout(image, title);
        this.title = title;
    }

    public FormStylePopup() {
        this.form = new FormStyleLayout();
    }

    public FormStylePopup(String image, String title, Integer width, Boolean shadow) {
        this(image, title);
        this.shadow = shadow;
        this.width = width;
    }

    public void clear() {
        this.form.clear();
    }

    public void addAttribute(String label, Widget wid) {
        this.form.addAttribute(label, wid);
    }

    public void addRow(Widget wid) {
        this.form.addRow(wid);
    }

    public void hide() {
        if (this.dialog != null) {
            this.dialog.hide();
            this.dialog.destroy();
        }
    }

    public void setPopupPosition(int left, int top) {
        this.popLeft = left;
        this.popTop = top;
    }

    public void setAfterShow(Command c) {
        this.afterShowEvent = c;
    }

    public void show() {
        this.dialog = new Window();
        this.dialog.setAutoScroll(true);
        this.dialog.setModal(this.modal);
        this.dialog.setPlain(true);
        this.dialog.setConstrainHeader(true);
        this.dialog.setBodyBorder(false);
        this.dialog.setBorder(false);
        if (this.width == null) {
            this.dialog.setWidth(430);
        } else if (this.width != -1) {
            this.dialog.setWidth(this.width.intValue());
        }
        this.dialog.setShadow(this.shadow == null ? true : this.shadow);
        this.dialog.setResizable(true);
        this.dialog.setClosable(true);
        this.dialog.setTitle(this.title);
        if (this.popLeft > -1) {
            this.dialog.setPosition(this.popLeft, this.popTop);
        }
        Panel p = new Panel();
        p.setLayout((ContainerLayout)new FitLayout());
        p.add((Widget)this.form);
        this.dialog.add((Component)p);
        p.setBodyBorder(false);
        p.setPaddings(0);
        if (this.afterShowEvent != null) {
            this.dialog.addListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.dialog.addListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.getHeight() != null) {
            this.dialog.setHeight(this.getHeight().intValue());
        }
        this.dialog.show();
    }

    public boolean isVisible() {
        if (this.dialog == null) {
            return false;
        }
        return this.dialog.isVisible();
    }

    public void setModal(boolean m) {
        this.modal = m;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public void setWidth(int i) {
        this.width = new Integer(i);
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    static /* synthetic */ Command access$000(FormStylePopup x0) {
        return x0.afterShowEvent;
    }

    static /* synthetic */ Window access$100(FormStylePopup x0) {
        return x0.dialog;
    }
}

