/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rulefloweditor;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.client.rulefloweditor.ElementContainerNode;
import org.drools.guvnor.client.rulefloweditor.RuleFlowBaseNode;
import org.drools.guvnor.client.rulefloweditor.RuleFlowConnectionFactory;
import org.drools.guvnor.client.rulefloweditor.RuleFlowNodeFactory;
import org.drools.guvnor.client.rulefloweditor.TransferConnection;
import org.drools.guvnor.client.rulefloweditor.TransferNode;
import org.drools.guvnor.client.rulefloweditor.TransferRuleFlowNodeFactory;
import pl.balon.gwt.diagrams.client.connection.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowViewer
extends AbsolutePanel {
    private Map<Long, RuleFlowBaseNode> nodes = new HashMap();
    private List<Connection> connections = new ArrayList();

    public RuleFlowViewer(RuleFlowContentModel rfcm, FormStyleLayout parametersForm) {
        int width = 600;
        int height = 600;
        for (TransferNode tn : rfcm.getNodes()) {
            RuleFlowBaseNode node = RuleFlowNodeFactory.createNode((TransferNode)tn);
            if (node == null) continue;
            if (node instanceof ElementContainerNode) {
                this.addElementContainerNodeSubNodes((ElementContainerNode)node, parametersForm);
            }
            node.addParametersForm(parametersForm);
            if (tn.getX() + tn.width > width) {
                width = tn.getX() + tn.width + 20;
            }
            if (tn.getY() + tn.height > height) {
                height = tn.getY() + tn.height + 20;
            }
            this.add((Widget)node, node.getX(), node.getY());
            this.nodes.put(node.getId(), node);
        }
        for (TransferConnection c : rfcm.getConnections()) {
            try {
                Connection connection = RuleFlowConnectionFactory.createConnection((TransferConnection)c, (Map)this.nodes);
                this.connections.add(connection);
                connection.appendTo((AbsolutePanel)this);
            }
            catch (Exception e) {}
        }
        this.setHeight(height + "px");
        this.setWidth(width + "px");
    }

    private void addElementContainerNodeSubNodes(ElementContainerNode fen, FormStyleLayout parametersForm) {
        for (RuleFlowBaseNode node : fen.getNodes().values()) {
            node.addParametersForm(parametersForm);
            if (!(node instanceof ElementContainerNode)) continue;
            this.addElementContainerNodeSubNodes((ElementContainerNode)node, parametersForm);
        }
    }

    public void update() {
        if (this.connections != null) {
            for (Connection c : this.connections) {
                c.update();
            }
        }
        for (RuleFlowBaseNode node : this.nodes.values()) {
            if (!(node instanceof ElementContainerNode)) continue;
            ((ElementContainerNode)node).update();
        }
    }

    public List<TransferNode> getTransferNodes() {
        ArrayList<TransferNode> transferNodes = new ArrayList<TransferNode>();
        for (RuleFlowBaseNode node : this.nodes.values()) {
            transferNodes.add(TransferRuleFlowNodeFactory.createNode((RuleFlowBaseNode)node));
        }
        return transferNodes;
    }
}

