/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.util.Base64;
import org.drools.guvnor.server.files.FileManagerUtils;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.util.TestEnvironmentSessionHelper;
import org.drools.repository.RulesRepository;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 510L;
    public static final Logger log = LoggerFactory.getLogger(RepositoryServlet.class);

    public FileManagerUtils getFileManager() {
        if (Contexts.isApplicationContextActive()) {
            return (FileManagerUtils)Component.getInstance((String)"fileManager");
        }
        log.debug("WARNING: RUNNING IN NON SEAM MODE SINGLE USER MODE - ONLY FOR TESTING AND DEBUGGING !!!!!");
        FileManagerUtils manager = new FileManagerUtils();
        try {
            manager.setRepository(new RulesRepository(TestEnvironmentSessionHelper.getSession((boolean)false)));
            return manager;
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    void doAuthorizedAction(HttpServletRequest req, HttpServletResponse res, A action) throws IOException {
        String auth = req.getHeader("Authorization");
        if (!RepositoryServlet.allowUser((String)auth)) {
            res.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
            res.sendError(401);
        } else {
            try {
                action.a();
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean allowUser(String auth) {
        if (auth == null) {
            return false;
        }
        if (!auth.toUpperCase(Locale.ENGLISH).startsWith("BASIC ")) {
            return false;
        }
        String[] a = RepositoryServlet.unpack((String)auth);
        String usr = a[0];
        String pwd = a[1];
        if (Contexts.isApplicationContextActive()) {
            Identity ids = Identity.instance();
            ids.getCredentials().setUsername(usr);
            ids.getCredentials().setPassword(pwd);
            try {
                ids.authenticate();
                log.info(usr + " authenticated for rest api");
                return true;
            }
            catch (LoginException e) {
                log.warn("Unable to authenticate for rest api: " + usr);
                return false;
            }
        }
        return usr.equals("test") && pwd.equals("password");
    }

    static String[] unpack(String auth) {
        String userpassEncoded = auth.substring(6);
        String userpassDecoded = new String(Base64.decode((byte[])userpassEncoded.getBytes()));
        String[] a = userpassDecoded.split(":");
        a[0] = a[0].trim();
        a[1] = a[1].trim();
        return a;
    }
}

