/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.MethodParameterValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldFunction;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;

public class ActionCallMethodWidget
extends RuleModellerWidget {
    private final ActionCallMethod model;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private String[] fieldCompletionTexts;
    private String[] fieldCompletionValues;
    private String variableClass;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private boolean readOnly;

    public ActionCallMethodWidget(RuleModeller mod, ActionCallMethod set) {
        this(mod, set, null);
    }

    public ActionCallMethodWidget(RuleModeller mod, ActionCallMethod set, Boolean readOnly) {
        super(mod);
        this.model = set;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        if (completions.isGlobalVariable(set.variable)) {
            List infos = completions.getMethodInfosForGlobalVariable(set.variable);
            this.fieldCompletionTexts = new String[infos.size()];
            this.fieldCompletionValues = new String[infos.size()];
            int i = 0;
            for (MethodInfo info : infos) {
                this.fieldCompletionTexts[i] = info.getName();
                this.fieldCompletionValues[i] = info.getNameWithParameters();
                ++i;
            }
            this.variableClass = completions.getGlobalVariable(set.variable);
        } else {
            FactPattern pattern = mod.getModel().getBoundFact(set.variable);
            if (pattern != null) {
                List methodList = completions.getMethodNames(pattern.factType);
                this.fieldCompletionTexts = new String[methodList.size()];
                this.fieldCompletionValues = new String[methodList.size()];
                int i = 0;
                Iterator i$ = methodList.iterator();
                while (i$.hasNext()) {
                    String methodName;
                    this.fieldCompletionTexts[i] = methodName = (String)i$.next();
                    this.fieldCompletionValues[i] = methodName;
                    ++i;
                }
                this.variableClass = pattern.factType;
                this.isBoundFact = true;
            } else {
                ActionInsertFact patternRhs = mod.getModel().getRhsBoundFact(set.variable);
                if (patternRhs != null) {
                    List methodList = completions.getMethodNames(patternRhs.factType);
                    this.fieldCompletionTexts = new String[methodList.size()];
                    this.fieldCompletionValues = new String[methodList.size()];
                    int i = 0;
                    Iterator i$ = methodList.iterator();
                    while (i$.hasNext()) {
                        String methodName;
                        this.fieldCompletionTexts[i] = methodName = (String)i$.next();
                        this.fieldCompletionValues[i] = methodName;
                        ++i;
                    }
                    this.variableClass = patternRhs.factType;
                    this.isBoundFact = true;
                }
            }
        }
        this.readOnly = readOnly == null ? !completions.containsFactType(this.variableClass) : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getSetterLabel());
        DirtyableFlexTable inner = new DirtyableFlexTable();
        int i = 0;
        while (i < this.model.fieldValues.length) {
            ActionFieldFunction val = this.model.getFieldValue(i);
            inner.setWidget(i, 0, this.fieldSelector(val));
            inner.setWidget(i, 1, this.valueEditor(val));
            int idx = i++;
        }
        this.layout.setWidget(0, 1, (Widget)inner);
    }

    private Widget getSetterLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        if (this.model.state == 0) {
            ImageButton edit = new ImageButton("images/add_field_to_fact.gif");
            edit.setTitle(this.constants.AddAnotherFieldToThisSoYouCanSetItsValue());
            edit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.model.variable + "]"));
            if (!this.readOnly) {
                horiz.add((Widget)edit);
            }
        } else {
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.model.variable + "." + this.model.methodName + "]"));
        }
        return horiz;
    }

    protected void showAddFieldPopup(Widget w) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        FormStylePopup popup = new FormStylePopup("images/newex_wiz.gif", this.constants.ChooseAMethodToInvoke());
        ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletionTexts.length; ++i) {
            box.addItem(this.fieldCompletionTexts[i], this.fieldCompletionValues[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(this.constants.ChooseAMethodToInvoke(), (Widget)box);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        popup.setPopupPosition(w.getAbsoluteLeft(), w.getAbsoluteTop());
        popup.show();
    }

    private Widget valueEditor(ActionFieldFunction val) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        String type = "";
        if (completions.isGlobalVariable(this.model.variable)) {
            type = completions.getGlobalVariable(this.model.variable);
        } else {
            type = this.getModeller().getModel().getBindingType(this.model.variable);
            if (type == null) {
                type = this.getModeller().getModel().getRhsBoundFact((String)this.model.variable).factType;
            }
        }
        DropDownData enums = completions.getEnums(type, this.model.fieldValues, val.field);
        return new MethodParameterValueEditor(val, enums, this.getModeller(), val.type, (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static KeyboardListener getNumericFilter(TextBox box) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Widget fieldSelector(ActionFieldFunction val) {
        return new SmallLabel(val.type);
    }

    private Widget actionSelector(ActionFieldFunction val) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        ListBox box = new ListBox();
        String fieldType = val.type;
        String[] modifiers = completions.getModifiers(fieldType);
        if (modifiers != null) {
            for (int i = 0; i < modifiers.length; ++i) {
                box.addItem(modifiers[i]);
            }
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    static /* synthetic */ ActionCallMethod access$000(ActionCallMethodWidget x0) {
        return x0.model;
    }

    static /* synthetic */ String access$100(ActionCallMethodWidget x0) {
        return x0.variableClass;
    }
}

