/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

public class RuleAttributeWidget
extends Composite {
    public static final String SALIENCE_ATTR = "salience";
    private static final String ENABLED_ATTR = "enabled";
    private static final String DATE_EFFECTIVE_ATTR = "date-effective";
    private static final String DATE_EXPIRES_ATTR = "date-expires";
    private static final String NO_LOOP_ATTR = "no-loop";
    private static final String AGENDA_GROUP_ATTR = "agenda-group";
    private static final String ACTIVATION_GROUP_ATTR = "activation-group";
    private static final String DURATION_ATTR = "duration";
    private static final String AUTO_FOCUS_ATTR = "auto-focus";
    private static final String LOCK_ON_ACTIVE_ATTR = "lock-on-active";
    private static final String RULEFLOW_GROUP_ATTR = "ruleflow-group";
    private static final String DIALECT_ATTR = "dialect";
    public static final String LOCK_LHS = "freeze_conditions";
    public static final String LOCK_RHS = "freeze_actions";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private RuleModel model;
    private RuleModeller parent;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public RuleAttributeWidget(RuleModeller parent, RuleModel model) {
        this.parent = parent;
        this.model = model;
        FormStyleLayout layout = new FormStyleLayout();
        RuleMetadata[] meta = model.metadataList;
        if (meta.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(this.constants.Metadata2()));
            layout.addRow((Widget)hp);
        }
        for (int i = 0; i < meta.length; ++i) {
            RuleMetadata rmd = meta[i];
            layout.addAttribute(rmd.attributeName, this.getEditorWidget(rmd, i));
        }
        RuleAttribute[] attrs = model.attributes;
        if (attrs.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(this.constants.Attributes1()));
            layout.addRow((Widget)hp);
        }
        for (int i = 0; i < attrs.length; ++i) {
            RuleAttribute at = attrs[i];
            layout.addAttribute(at.attributeName, this.getEditorWidget(at, i));
        }
        this.initWidget((Widget)layout);
    }

    public static ListBox getAttributeList() {
        Constants cons = (Constants)GWT.create(Constants.class);
        ListBox list = new ListBox();
        list.addItem(cons.Choose());
        list.addItem(SALIENCE_ATTR);
        list.addItem(ENABLED_ATTR);
        list.addItem(DATE_EFFECTIVE_ATTR);
        list.addItem(DATE_EXPIRES_ATTR);
        list.addItem(NO_LOOP_ATTR);
        list.addItem(AGENDA_GROUP_ATTR);
        list.addItem(ACTIVATION_GROUP_ATTR);
        list.addItem(DURATION_ATTR);
        list.addItem(AUTO_FOCUS_ATTR);
        list.addItem(LOCK_ON_ACTIVE_ATTR);
        list.addItem(RULEFLOW_GROUP_ATTR);
        list.addItem(DIALECT_ATTR);
        return list;
    }

    private Widget getEditorWidget(RuleAttribute at, int idx) {
        Object editor = at.attributeName.equals(ENABLED_ATTR) || at.attributeName.equals(AUTO_FOCUS_ATTR) || at.attributeName.equals(LOCK_ON_ACTIVE_ATTR) || at.attributeName.equals(NO_LOOP_ATTR) ? this.checkBoxEditor(at) : this.textBoxEditor(at);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add(editor);
        horiz.add((Widget)this.getRemoveIcon(idx));
        return horiz;
    }

    private Widget getEditorWidget(RuleMetadata rm, int idx) {
        Object editor = rm.attributeName.equals(LOCK_LHS) || rm.attributeName.equals(LOCK_RHS) ? new InfoPopup(this.constants.FrozenAreas(), this.constants.FrozenExplanation()) : this.textBoxEditor(rm);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)editor);
        horiz.add((Widget)this.getRemoveMetaIcon(idx));
        return horiz;
    }

    private Widget checkBoxEditor(RuleAttribute at) {
        CheckBox box = new CheckBox();
        if (at.value == null) {
            box.setChecked(true);
            at.value = TRUE_VALUE;
        } else {
            box.setChecked(at.value.equals(TRUE_VALUE));
        }
        box.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private TextBox textBoxEditor(RuleAttribute at) {
        TextBox box = new TextBox();
        box.setVisibleLength(at.value.length() < 3 ? 3 : at.value.length());
        box.setText(at.value);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        if (at.attributeName.equals(DATE_EFFECTIVE_ATTR) || at.attributeName.equals(DATE_EXPIRES_ATTR)) {
            if (at.value == null || "".equals(at.value)) {
                box.setText("");
            }
            box.setVisibleLength(10);
        }
        box.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private TextBox textBoxEditor(RuleMetadata rm) {
        TextBox box = new TextBox();
        box.setVisibleLength(rm.value.length() < 3 ? 3 : rm.value.length());
        box.setText(rm.value);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        box.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Image getRemoveIcon(int idx) {
        Image remove = new Image("images/delete_item_small.gif");
        remove.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return remove;
    }

    private Image getRemoveMetaIcon(int idx) {
        Image remove = new Image("images/delete_item_small.gif");
        remove.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return remove;
    }

    static /* synthetic */ Constants access$000(RuleAttributeWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ RuleModel access$100(RuleAttributeWidget x0) {
        return x0.model;
    }

    static /* synthetic */ RuleModeller access$200(RuleAttributeWidget x0) {
        return x0.parent;
    }
}

