/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.DatePickerTextBox;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDown;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldDataConstraintEditor
extends DirtyableComposite {
    private String factType;
    private FieldData field;
    private FactData givenFact;
    private final Panel panel;
    private Scenario scenario;
    private ExecutionTrace executionTrace;
    private SuggestionCompletionEngine sce;
    private ValueChanged callback;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public FieldDataConstraintEditor(String factType, ValueChanged callback, FieldData field, FactData givenFact, SuggestionCompletionEngine sce, Scenario scenario, ExecutionTrace exec) {
        this.field = field;
        this.sce = sce;
        this.factType = factType;
        this.callback = callback;
        this.scenario = scenario;
        this.executionTrace = exec;
        this.givenFact = givenFact;
        this.panel = new SimplePanel();
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void refreshEditor() {
        String key = this.factType + "." + this.field.name;
        String flType = this.sce.getFieldType(key);
        this.panel.clear();
        if (flType != null && flType.equals("Numeric")) {
            TextBox box = FieldDataConstraintEditor.editableTextBox((ValueChanged)this.callback, (String)this.field.name, (String)this.field.value);
            box.addKeyboardListener(ActionValueEditor.getNumericFilter((TextBox)box));
            this.panel.add((Widget)box);
        } else if (flType != null && flType.equals("Boolean")) {
            String[] c = new String[]{"true", "false"};
            this.panel.add((Widget)new EnumDropDown(this.field.value, (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, DropDownData.create((String[])c)));
        } else if (flType != null && flType.equals("Date")) {
            DatePickerTextBox datePicker = new DatePickerTextBox(this.field.value);
            String m = Format.format((String)((Constants)GWT.create(Constants.class)).ValueFor0(), (String)this.field.name);
            datePicker.setTitle(m);
            datePicker.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
            this.panel.add((Widget)datePicker);
        } else {
            String[] enums = this.sce.getDataEnumList(key);
            if (enums != null) {
                this.panel.add((Widget)new EnumDropDown(this.field.value, (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, DropDownData.create((String[])enums)));
            } else {
                if (this.field.value != null && this.field.value.length() > 0 && this.field.nature == 0L) {
                    this.field.nature = this.field.value.length() > 1 && this.field.value.charAt(1) == '[' && this.field.value.charAt(0) == '=' ? 1L : (this.field.value.charAt(0) == '=' ? 2L : 1L);
                }
                if (this.field.nature == 0L && (this.isThereABoundVariableToSet() || this.isItAList())) {
                    Image clickme = new Image("images/edit.gif");
                    clickme.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                    this.panel.add((Widget)clickme);
                } else if (this.field.nature == 2L) {
                    this.panel.add(this.variableEditor(this.callback));
                } else if (this.field.nature == 6L) {
                    this.panel.add(this.listEditor(this.callback));
                } else {
                    this.panel.add((Widget)FieldDataConstraintEditor.editableTextBox((ValueChanged)this.callback, (String)this.field.name, (String)this.field.value));
                }
            }
        }
    }

    private static TextBox editableTextBox(ValueChanged changed, String fieldName, String initialValue) {
        TextBox tb = new TextBox();
        tb.setText(initialValue);
        String m = Format.format((String)((Constants)GWT.create(Constants.class)).ValueFor0(), (String)fieldName);
        tb.setTitle(m);
        tb.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return tb;
    }

    private Widget variableEditor(ValueChanged changed) {
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        ListBox box = new ListBox();
        if (this.field.value == null) {
            box.addItem(this.constants.Choose());
        }
        int j = 0;
        for (int i = 0; i < vars.size(); ++i) {
            String var = (String)vars.get(i);
            Map m = this.scenario.getVariableTypes();
            FactData f = (FactData)this.scenario.getFactTypes().get(var);
            String fieldType = null;
            fieldType = this.field.collectionType == null ? this.sce.getFieldType(this.factType, this.field.name) : this.field.collectionType;
            if (!f.type.equals(fieldType)) continue;
            if (box.getItemCount() == 0) {
                box.addItem("...");
                ++j;
            }
            box.addItem("=" + var);
            if (this.field.value != null && this.field.value.equals("=" + var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget listEditor(ValueChanged changed) {
        VerticalPanel panel = new VerticalPanel();
        int i = 0;
        for (FieldData f : this.field.collectionFieldList) {
            DirtyableHorizontalPane hpanel = new DirtyableHorizontalPane();
            FieldDataConstraintEditor fieldElement = new FieldDataConstraintEditor(f.collectionType, (ValueChanged)new /* Unavailable Anonymous Inner Class!! */, f, this.givenFact, this.sce, this.scenario, this.executionTrace);
            hpanel.add((Widget)fieldElement);
            int index = i++;
            ImageButton del = new ImageButton("images/delete_item_small.gif", Format.format((String)this.constants.AElementToDelInCollectionList(), (String)"tt"), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)del);
            ImageButton addPattern = new ImageButton("images/new_item_below.png");
            addPattern.setTitle(this.constants.AddElementBelow());
            addPattern.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)addPattern);
            ImageButton moveDown = new ImageButton("images/shuffle_down.gif");
            moveDown.setTitle(this.constants.MoveDownListMove());
            moveDown.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)moveDown);
            ImageButton moveUp = new ImageButton("images/shuffle_up.gif");
            moveUp.setTitle(this.constants.MoveUpList());
            moveUp.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)moveUp);
            panel.add((Widget)hpanel);
        }
        if (this.field.collectionFieldList.size() == 0) {
            ImageButton add = new ImageButton("images/new_item.gif", Format.format((String)this.constants.AElementToAddInCollectionList(), (String)"tt"), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            panel.add((Widget)add);
        }
        return panel;
    }

    private void calculateValueFromList() {
        if (this.field.collectionFieldList == null || this.field.collectionFieldList.isEmpty()) {
            this.field.value = "=[]";
            return;
        }
        StringBuffer listContent = new StringBuffer();
        for (FieldData f : this.field.collectionFieldList) {
            listContent.append(',');
            if (f.value == null) continue;
            listContent.append(f.value.substring(1));
        }
        this.field.value = "=[" + listContent.substring(1) + "]";
    }

    private void showTypeChoice(Widget w, FieldData con) {
        Button variable;
        FormStylePopup form = new FormStylePopup("images/newex_wiz.gif", this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(this.constants.LiteralValue(), this.constants.LiteralValTip())));
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(this.constants.AdvancedOptions()));
        if (this.isThereABoundVariableToSet()) {
            variable = new Button(this.constants.BoundVariable());
            variable.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.ABoundVariable(), this.constants.BoundVariableTip())));
        }
        if (this.isItAList()) {
            variable = new Button(this.constants.GuidedList());
            variable.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.AGuidedList(), this.constants.AGuidedListTip())));
        }
        form.show();
    }

    private boolean isThereABoundVariableToSet() {
        boolean retour = false;
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        if (vars.size() > 0) {
            for (int i = 0; i < vars.size(); ++i) {
                String var = (String)vars.get(i);
                Map m = this.scenario.getVariableTypes();
                FactData f = (FactData)this.scenario.getFactTypes().get(var);
                String fieldType = null;
                fieldType = this.field.collectionType == null ? this.sce.getFieldType(this.factType, this.field.name) : this.field.collectionType;
                if (!f.type.equals(fieldType)) continue;
                retour = true;
                break;
            }
        }
        return retour;
    }

    private boolean isItAList() {
        boolean retour = false;
        String fieldType = this.sce.getFieldType(this.factType, this.field.name);
        if (fieldType != null && fieldType.equals("Collection")) {
            retour = true;
        }
        return retour;
    }

    private void doTypeChosen(FormStylePopup form) {
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    static /* synthetic */ ValueChanged access$000(FieldDataConstraintEditor x0) {
        return x0.callback;
    }

    static /* synthetic */ FieldData access$100(FieldDataConstraintEditor x0) {
        return x0.field;
    }

    static /* synthetic */ void access$200(FieldDataConstraintEditor x0, Widget x1, FieldData x2) {
        x0.showTypeChoice(x1, x2);
    }

    static /* synthetic */ void access$300(FieldDataConstraintEditor x0) {
        x0.calculateValueFromList();
    }

    static /* synthetic */ void access$400(FieldDataConstraintEditor x0) {
        x0.refreshEditor();
    }

    static /* synthetic */ void access$500(FieldDataConstraintEditor x0, FormStylePopup x1) {
        x0.doTypeChosen(x1);
    }

    static /* synthetic */ String access$600(FieldDataConstraintEditor x0) {
        return x0.factType;
    }

    static /* synthetic */ SuggestionCompletionEngine access$700(FieldDataConstraintEditor x0) {
        return x0.sce;
    }
}

