/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.qa.VerifyRulesFiredWidget;
import org.drools.guvnor.client.qa.testscenarios.AddExecuteButton;
import org.drools.guvnor.client.qa.testscenarios.ConfigWidget;
import org.drools.guvnor.client.qa.testscenarios.ExecutionWidget;
import org.drools.guvnor.client.qa.testscenarios.ExpectPanel;
import org.drools.guvnor.client.qa.testscenarios.GivenLabelButton;
import org.drools.guvnor.client.qa.testscenarios.GivenPanel;
import org.drools.guvnor.client.qa.testscenarios.GlobalButton;
import org.drools.guvnor.client.qa.testscenarios.GlobalPanel;
import org.drools.guvnor.client.qa.testscenarios.RuleSelectionEvent;
import org.drools.guvnor.client.qa.testscenarios.ScenarioHelper;
import org.drools.guvnor.client.qa.testscenarios.TestRunnerWidget;
import org.drools.guvnor.client.qa.testscenarios.VerifyFactsPanel;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.FixtureList;
import org.drools.ide.common.client.modeldriven.testing.FixturesMap;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ScenarioWidget
extends Composite {
    private String[] availableRules;
    protected final SuggestionCompletionEngine suggestionCompletionEngine;
    private ChangeListener ruleSelectionCL;
    final RuleAsset asset;
    private final Scenario scenario;
    final VerticalPanel layout;
    boolean showResults;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public ScenarioWidget(RuleAsset asset, RuleViewer viewer) {
        this(asset);
    }

    public ScenarioWidget(RuleAsset asset) {
        this.asset = asset;
        this.layout = new VerticalPanel();
        this.showResults = false;
        this.suggestionCompletionEngine = SuggestionCompletionCache.getInstance().getEngineFromCache(asset.metaData.packageName);
        this.scenario = (Scenario)asset.content;
        if (this.scenario.fixtures.size() == 0) {
            this.scenario.fixtures.add(new ExecutionTrace());
        }
        if (!asset.isreadonly) {
            this.layout.add((Widget)new TestRunnerWidget(this, asset.metaData.packageName));
        }
        this.renderEditor();
        this.initWidget((Widget)this.layout);
        this.setStyleName("scenario-Viewer");
        this.layout.setWidth("100%");
    }

    void renderEditor() {
        if (this.layout.getWidgetCount() == 2) {
            this.layout.remove(1);
        }
        DirtyableFlexTable editorLayout = new DirtyableFlexTable();
        editorLayout.clear();
        editorLayout.setWidth("100%");
        editorLayout.setStyleName("model-builder-Background");
        this.layout.add((Widget)editorLayout);
        ScenarioHelper scenarioHelper = new ScenarioHelper();
        List fixtures = scenarioHelper.lumpyMap(this.scenario.fixtures);
        ArrayList<ExecutionTrace> listExecutionTrace = new ArrayList<ExecutionTrace>();
        for (int i = 0; i < fixtures.size(); ++i) {
            Object fixture = fixtures.get(i);
            if (!(fixture instanceof ExecutionTrace)) continue;
            listExecutionTrace.add((ExecutionTrace)fixture);
        }
        int layoutRow = 1;
        int executionTraceLine = 0;
        ExecutionTrace previousEx = null;
        for (int i = 0; i < fixtures.size(); ++i) {
            Fixture fixture = (Fixture)fixtures.get(i);
            if (fixture instanceof ExecutionTrace) {
                previousEx = (ExecutionTrace)fixture;
                editorLayout.setWidget(layoutRow, 0, (Widget)new ExpectPanel(this.asset.metaData.packageName, previousEx, this.scenario, this));
                if (++executionTraceLine >= listExecutionTrace.size()) {
                    executionTraceLine = listExecutionTrace.size() - 1;
                }
                editorLayout.setWidget(layoutRow, 1, (Widget)new ExecutionWidget(previousEx, this.showResults));
                editorLayout.getFlexCellFormatter().setHorizontalAlignment(layoutRow, 2, HasHorizontalAlignment.ALIGN_LEFT);
            } else if (fixture instanceof FixturesMap) {
                editorLayout.setWidget(layoutRow, 0, (Widget)new GivenLabelButton(previousEx, this.scenario, (ExecutionTrace)listExecutionTrace.get(executionTraceLine), this));
                ++layoutRow;
                if (fixture instanceof FixturesMap) {
                    editorLayout.setWidget(layoutRow, 1, this.newGivenPanel(listExecutionTrace, executionTraceLine, (FixturesMap)fixture));
                }
            } else {
                FixtureList fixturesList = (FixtureList)fixture;
                Fixture first = (Fixture)fixturesList.get(0);
                if (first instanceof VerifyFact) {
                    editorLayout.setWidget(layoutRow, 1, (Widget)new VerifyFactsPanel(fixturesList, (ExecutionTrace)listExecutionTrace.get(executionTraceLine), this.scenario, this, this.showResults));
                } else if (first instanceof VerifyRuleFired) {
                    editorLayout.setWidget(layoutRow, 1, (Widget)new VerifyRulesFiredWidget((List)fixturesList, this.scenario, this.showResults));
                }
            }
            ++layoutRow;
        }
        editorLayout.setWidget(layoutRow, 0, (Widget)new AddExecuteButton(this.scenario, this));
        editorLayout.setWidget(++layoutRow, 0, (Widget)new SmallLabel(this.constants.configuration()));
        editorLayout.setWidget(layoutRow, 1, (Widget)new ConfigWidget(this.scenario, this.asset.metaData.packageName, this));
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)new GlobalButton(this.scenario, this));
        h.add((Widget)new SmallLabel(this.constants.globals()));
        editorLayout.setWidget(++layoutRow, 0, (Widget)h);
        editorLayout.setWidget(layoutRow, 1, (Widget)new GlobalPanel(scenarioHelper.lumpyMapGlobals(this.scenario.globals), this.scenario, previousEx, this));
    }

    private Widget newGivenPanel(List<ExecutionTrace> listExecutionTrace, int executionTraceLine, FixturesMap given) {
        if (given.size() > 0) {
            return new GivenPanel(listExecutionTrace, executionTraceLine, given, this.scenario, this);
        }
        return new HTML("<i><small>" + this.constants.AddInputDataAndExpectationsHere() + "</small></i>");
    }

    public Widget getRuleSelectionWidget(String packageName, RuleSelectionEvent selected) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        TextBox ruleNameTextBox = new TextBox();
        ruleNameTextBox.setTitle(this.constants.EnterRuleNameScenario());
        horizontalPanel.add((Widget)ruleNameTextBox);
        if (this.availableRules != null) {
            ListBox availableRulesBox = new ListBox();
            availableRulesBox.addItem(this.constants.pleaseChoose1());
            for (int i = 0; i < this.availableRules.length; ++i) {
                availableRulesBox.addItem(this.availableRules[i]);
            }
            availableRulesBox.setSelectedIndex(0);
            availableRulesBox.removeChangeListener(this.ruleSelectionCL);
            this.ruleSelectionCL = new /* Unavailable Anonymous Inner Class!! */;
            availableRulesBox.addChangeListener(this.ruleSelectionCL);
            horizontalPanel.add((Widget)availableRulesBox);
        } else {
            Button showList = new Button(this.constants.showListButton());
            horizontalPanel.add((Widget)showList);
            showList.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        Button ok = new Button(this.constants.OK());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horizontalPanel.add((Widget)ok);
        return horizontalPanel;
    }

    public static Widget getBar(String colour, int width, float percent) {
        int pixels = (int)((float)width * (percent / 100.0f));
        String html = "<div class=\"smallish-progress-wrapper\" style=\"width: " + width + "px\">" + "<div class=\"smallish-progress-bar\" style=\"width: " + pixels + "px; background-color: " + colour + ";\"></div>" + "<div class=\"smallish-progress-text\" style=\"width: " + width + "px\">" + (int)percent + "%</div></div>";
        return new HTML(html);
    }

    public static Widget getBar(String colour, int width, int numerator, int denominator) {
        int percent = 0;
        if (denominator != 0) {
            percent = (int)(((float)denominator - (float)numerator) / (float)denominator * 100.0f);
        }
        return ScenarioWidget.getBar((String)colour, (int)width, (float)percent);
    }

    static /* synthetic */ Constants access$000(ScenarioWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ String[] access$102(ScenarioWidget x0, String[] x1) {
        x0.availableRules = x1;
        return x1;
    }

    static /* synthetic */ ChangeListener access$202(ScenarioWidget x0, ChangeListener x1) {
        x0.ruleSelectionCL = x1;
        return x0.ruleSelectionCL;
    }

    static /* synthetic */ ChangeListener access$200(ScenarioWidget x0) {
        return x0.ruleSelectionCL;
    }
}

