/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.form.FormPanel;
import java.util.Date;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.ExplorerLayoutManager;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.ruleeditor.AssetCategoryEditor;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.VersionBrowser;
import org.drools.guvnor.client.security.Capabilities;

public class MetaDataWidget
extends Composite {
    private MetaData data;
    private boolean readOnly;
    private String uuid;
    private Command metaDataRefreshView;
    private Command fullRefreshView;
    private VerticalPanel layout = new VerticalPanel();
    AssetCategoryEditor ed;
    private FormStyleLayout currentSection;
    private String currentSectionName;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public MetaDataWidget(MetaData d, boolean readOnly, String uuid, Command metaDataRefreshView, Command fullRefreshView) {
        this.metaDataRefreshView = metaDataRefreshView;
        this.fullRefreshView = fullRefreshView;
        if (d.format.equals("drl") || d.format.equals("function") || d.format.equals("enumeration")) {
            this.render(d, readOnly, uuid);
        } else {
            Button show = new Button(this.constants.showMoreInfo());
            show.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.layout.add((Widget)new SmallLabel(Format.format((String)"Title: [<b>{0}</b>]", (String)d.name)));
            this.layout.add((Widget)show);
        }
        this.initWidget((Widget)this.layout);
    }

    private void render(MetaData d, boolean readOnly, String uuid) {
        if (!readOnly) {
            ImageButton edit = new ImageButton("images/edit.gif", this.constants.RenameThisAsset());
            edit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.addHeader("images/meta_data.png", d.name, (Image)edit);
        } else {
            this.addHeader("images/asset_version.png", d.name, null);
        }
        this.uuid = uuid;
        this.data = d;
        this.readOnly = readOnly;
        this.loadData(d);
    }

    private void addHeader(String img, String name, Image edit) {
        this.startSection(name);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new SmallLabel("<b>" + name + "</b>"));
        if (edit != null) {
            hp.add((Widget)edit);
        }
        this.currentSection.addAttribute(this.constants.Title(), (Widget)hp);
    }

    private void loadData(MetaData d) {
        this.data = d;
        this.addAttribute(this.constants.CategoriesMetaData(), this.categories());
        this.addAttribute(this.constants.ModifiedOnMetaData(), this.readOnlyDate(this.data.lastModifiedDate));
        this.addAttribute(this.constants.ModifiedByMetaData(), (Widget)this.readOnlyText(this.data.lastContributor));
        this.addAttribute(this.constants.NoteMetaData(), (Widget)this.readOnlyText(this.data.checkinComment));
        if (!this.readOnly) {
            this.addAttribute(this.constants.CreatedOnMetaData(), this.readOnlyDate(this.data.createdDate));
        }
        this.addAttribute(this.constants.CreatedByMetaData(), (Widget)this.readOnlyText(this.data.creator));
        this.addAttribute(this.constants.FormatMetaData(), (Widget)new SmallLabel("<b>" + this.data.format + "</b>"));
        this.addAttribute(this.constants.PackageMetaData(), this.packageEditor(this.data.packageName));
        this.addAttribute(this.constants.IsDisabledMetaData(), this.editableBoolean((FieldBooleanBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.DisableTip()));
        this.addAttribute("UUID:", (Widget)this.readOnlyText(this.uuid));
        this.endSection();
        this.startSection(this.constants.OtherMetaData());
        this.addAttribute(this.constants.SubjectMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.AShortDescriptionOfTheSubjectMatter()));
        this.addAttribute(this.constants.TypeMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.TypeTip()));
        this.addAttribute(this.constants.ExternalLinkMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.ExternalLinkTip()));
        this.addAttribute(this.constants.SourceMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.SourceMetaDataTip()));
        this.endSection(true);
        this.startSection(this.constants.VersionHistory());
        this.addAttribute(this.constants.CurrentVersionNumber(), this.getVersionNumberLabel());
        if (!this.readOnly) {
            this.addRow(new VersionBrowser(this.uuid, this.data, this.fullRefreshView));
        }
        this.endSection(true);
    }

    private void addRow(VersionBrowser versionBrowser) {
        this.currentSection.addRow((Widget)versionBrowser);
    }

    private void addAttribute(String string, Widget editable) {
        this.currentSection.addAttribute(string, editable);
    }

    private void endSection() {
        this.endSection(false);
    }

    private void endSection(boolean collapsed) {
        FormPanel config = new FormPanel();
        config.setTitle(this.currentSectionName);
        config.setCollapsible(true);
        config.setCollapsed(collapsed);
        config.add((Widget)this.currentSection);
        this.layout.add((Widget)config);
    }

    private void startSection(String name) {
        this.currentSection = new FormStyleLayout();
        this.currentSectionName = name;
    }

    private Widget packageEditor(String packageName) {
        if (this.readOnly || !ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            return this.readOnlyText(packageName);
        }
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.setStyleName("metadata-Widget");
        horiz.add((Widget)this.readOnlyText(packageName));
        ImageButton editPackage = new ImageButton("images/edit.gif");
        editPackage.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)editPackage);
        return horiz;
    }

    private void showRenameAsset(Widget source) {
        FormStylePopup pop = new FormStylePopup("images/package_large.png", this.constants.RenameThisItem());
        TextBox box = new TextBox();
        box.setText(this.data.name);
        pop.addAttribute(this.constants.NewNameAsset(), (Widget)box);
        Button ok = new Button(this.constants.RenameItem());
        pop.addAttribute("", (Widget)ok);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void showEditPackage(String pkg, Widget source) {
        FormStylePopup pop = new FormStylePopup("images/package_large.png", this.constants.MoveThisItemToAnotherPackage());
        pop.addAttribute(this.constants.CurrentPackage(), (Widget)new Label(pkg));
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(this.constants.NewPackage(), (Widget)sel);
        Button ok = new Button(this.constants.ChangePackage());
        pop.addAttribute("", (Widget)ok);
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private Widget getVersionNumberLabel() {
        if (this.data.versionNumber == 0L) {
            return new SmallLabel(this.constants.NotCheckedInYet());
        }
        return this.readOnlyText(Long.toString(this.data.versionNumber));
    }

    private Widget readOnlyDate(Date lastModifiedDate) {
        if (lastModifiedDate == null) {
            return null;
        }
        return new SmallLabel(lastModifiedDate.toLocaleString());
    }

    private Label readOnlyText(String text) {
        SmallLabel lbl = new SmallLabel(text);
        lbl.setWidth("100%");
        return lbl;
    }

    private Widget categories() {
        this.ed = new AssetCategoryEditor(this.data, this.readOnly);
        return this.ed;
    }

    private Widget editableText(FieldBinding bind, String toolTip) {
        if (!this.readOnly) {
            TextBox box = new TextBox();
            box.setTitle(toolTip);
            box.setText(bind.getValue());
            box.setVisibleLength(10);
            11 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addChangeListener((ChangeListener)listener);
            return box;
        }
        return new Label(bind.getValue());
    }

    private Widget editableBoolean(FieldBooleanBinding bind, String toolTip) {
        if (!this.readOnly) {
            CheckBox box = new CheckBox();
            box.setTitle(toolTip);
            box.setChecked(bind.getValue());
            12 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addClickListener((ClickListener)listener);
            return box;
        }
        CheckBox box = new CheckBox();
        box.setChecked(bind.getValue());
        box.setEnabled(false);
        return box;
    }

    public MetaData getData() {
        return this.data;
    }

    static /* synthetic */ VerticalPanel access$000(MetaDataWidget x0) {
        return x0.layout;
    }

    static /* synthetic */ void access$100(MetaDataWidget x0, MetaData x1, boolean x2, String x3) {
        x0.render(x1, x2, x3);
    }

    static /* synthetic */ void access$200(MetaDataWidget x0, Widget x1) {
        x0.showRenameAsset(x1);
    }

    static /* synthetic */ MetaData access$300(MetaDataWidget x0) {
        return x0.data;
    }

    static /* synthetic */ void access$400(MetaDataWidget x0, String x1, Widget x2) {
        x0.showEditPackage(x1, x2);
    }

    static /* synthetic */ String access$500(MetaDataWidget x0) {
        return x0.uuid;
    }

    static /* synthetic */ Command access$600(MetaDataWidget x0) {
        return x0.metaDataRefreshView;
    }

    static /* synthetic */ Constants access$700(MetaDataWidget x0) {
        return x0.constants;
    }
}

