/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

public class BRLContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializationException {
        asset.content = this.getBrlXmlPersistence().unmarshal(item.getContent());
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleModel data = (RuleModel)asset.content;
        if (data.name == null) {
            data.name = repoAsset.getName();
        }
        repoAsset.updateContent(this.getBrlXmlPersistence().marshal(data));
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        builder.addPackageFromDrl((Reader)new StringReader(this.getSourceDRL(asset, builder)));
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuffer buf) {
        String drl = this.getSourceDRL(asset, builder);
        buf.append(drl);
    }

    private String getSourceDRL(AssetItem asset, BRMSPackageBuilder builder) {
        RuleModel model = this.buildModelFromAsset(asset);
        String drl = this.getBrlDrlPersistence().marshal(model);
        if (builder.hasDSL() && model.hasDSLSentences()) {
            drl = builder.getDSLExpander().expand(drl);
        }
        return drl;
    }

    protected RuleModel buildModelFromAsset(AssetItem asset) {
        RuleModel model = this.getBrlXmlPersistence().unmarshal(asset.getContent());
        model.name = asset.getName();
        model.parentName = this.parentNameFromCategory(asset, model.parentName);
        return model;
    }

    public String getRawDRL(AssetItem asset) {
        RuleModel model = this.getBrlXmlPersistence().unmarshal(asset.getContent());
        return this.getBrlDrlPersistence().marshal(model);
    }

    protected BRLPersistence getBrlDrlPersistence() {
        return BRDRLPersistence.getInstance();
    }

    protected BRLPersistence getBrlXmlPersistence() {
        return BRXMLPersistence.getInstance();
    }
}

