/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.DefaultContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ContentManager {
    private static final Logger log = LoggerFactory.getLogger(ContentManager.class);
    public static String CONTENT_CONFIG_PROPERTIES = "/contenthandler.properties";
    private static ContentManager INSTANCE;
    private final Map<String, ContentHandler> contentHandlers = new HashMap();

    ContentManager(String configPath) {
        log.debug("Loading content properties");
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(configPath));
            for (String string : props.keySet()) {
                String val = props.getProperty(string);
                this.contentHandlers.put(string, this.loadContentHandlerImplementation(val));
            }
        }
        catch (IOException e) {
            log.error("UNABLE to load content handlers. Ahem, nothing will actually work. Ignore subsequent errors until this is resolved.", (Throwable)e);
        }
    }

    public Map<String, ContentHandler> getContentHandlers() {
        return this.contentHandlers;
    }

    private ContentHandler loadContentHandlerImplementation(String val) throws IOException {
        try {
            return (ContentHandler)Thread.currentThread().getContextClassLoader().loadClass(val).newInstance();
        }
        catch (InstantiationException e) {
            log.error("Unable to load content handler implementation.", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error("Unable to load content handler implementation.", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load content handler implementation.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ContentManager> clazz = ContentManager.class;
        synchronized (ContentManager.class) {
            INSTANCE = new ContentManager(CONTENT_CONFIG_PROPERTIES);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static ContentHandler getHandler(String format) {
        ContentHandler h = (ContentHandler)ContentManager.getInstance().getContentHandlers().get(format);
        if (h == null) {
            h = new DefaultContentHandler();
        }
        return h;
    }
}

