/*
 * Decompiled with CFR 0.152.
 */
package org.gridcc.mce.mceworkflow.servlets;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.AssetFileServlet;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowManagerServlet
extends AssetFileServlet {
    private static final long serialVersionUID = 510L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String operation = request.getParameter("operation");
        if (operation != null) {
            if (operation.equalsIgnoreCase("download")) {
                this.downloadWorkflow(request, response);
            } else if (operation.equalsIgnoreCase("retrieve")) {
                this.retrieveWorkflow(request, response);
            } else if (operation.equalsIgnoreCase("save")) {
                this.saveWorkflow(request, response);
            }
        }
    }

    private String getFullPath(String path, String workflowName, String extension, String fileName) {
        if (fileName.indexOf("wsdlCatalog") >= 0) {
            return path + workflowName + "/META-INF";
        }
        return this.getFullPath(path, workflowName, extension);
    }

    private String getFullPath(String path, String workflowName, String extension) {
        String fullPath = path;
        if (extension.equals("bpr")) {
            fullPath = fullPath + workflowName + "/bpr";
        } else if (extension.equals("bpel")) {
            fullPath = fullPath + workflowName + "/bpel/" + workflowName;
        } else if (extension.equals("wsdl") || extension.equals("xsd")) {
            fullPath = fullPath + workflowName + "/wsdl/" + workflowName + "/wsdl";
        } else if (extension.equals("xml")) {
            fullPath = fullPath + workflowName + "/submission";
        } else if (extension.equals("pdd")) {
            fullPath = fullPath + workflowName + "/META-INF/pdd/" + workflowName;
        }
        return fullPath;
    }

    private void downloadWorkflow(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uuid = request.getParameter("uuid");
        if (uuid == null) {
            return;
        }
        try {
            this.processAttachmentDownload(uuid, response);
        }
        catch (Exception e) {
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print("<h2>Sorry, file cannot be found!</h2>");
            writer.close();
        }
    }

    private void retrieveWorkflow(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uuid = request.getParameter("uuid");
        String fullPath = "";
        String fileName = request.getParameter("fileName");
        String workflowName = request.getParameter("workflowName");
        if (fileName == null || workflowName == null || fullPath == null) {
            return;
        }
        String extension = fileName.substring(fileName.indexOf(46) + 1);
        fullPath = this.getFullPath(fullPath, workflowName, extension, fileName);
        fullPath = fullPath + "/" + fileName;
        try {
            JarEntry entry;
            AssetItem item = this.getFileManager().getRepository().loadAssetByUUID(uuid);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JarInputStream jis = new JarInputStream(item.getBinaryContentAttachment());
            byte[] buf = new byte[1024];
            while ((entry = jis.getNextJarEntry()) != null) {
                int len;
                if (!entry.getName().equals(fullPath)) continue;
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                break block2;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
            String line = null;
            StringBuffer sb = new StringBuffer(36864);
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            out.close();
            jis.close();
            reader.close();
            response.setContentType("text/plain");
            PrintWriter writer = response.getWriter();
            writer.print(sb);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print("<h2>Sorry, that file cannot be found</h2>");
            writer.close();
        }
    }

    private void saveWorkflow(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uuid = request.getParameter("uuid");
        String fullPath = "";
        String fileName = request.getParameter("fileName");
        String workflowName = request.getParameter("workflowName");
        if (fileName == null || workflowName == null || fullPath == null) {
            return;
        }
        String extension = fileName.substring(fileName.indexOf(46) + 1);
        String fullPathToFolder = this.getFullPath(fullPath, workflowName, extension, fileName);
        fullPath = fullPathToFolder + "/" + fileName;
        AssetItem item = this.getFileManager().getRepository().loadAssetByUUID(uuid);
        InputStream in = item.getBinaryContentAttachment();
        String fileContent = request.getParameter("fileContent");
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream(bais);
        ZipInputStream jis = null;
        try {
            if (in == null) {
                jos.putNextEntry(new JarEntry(fullPath));
                ByteArrayInputStream i = new ByteArrayInputStream(fileContent.getBytes());
                int len = 0;
                byte[] copyBuf = new byte[1024];
                while (len != -1) {
                    len = i.read(copyBuf, 0, copyBuf.length);
                    if (len <= 0) continue;
                    jos.write(copyBuf, 0, len);
                }
                i.close();
                jos.closeEntry();
            } else {
                JarEntry entry;
                jis = new JarInputStream(in);
                boolean found = false;
                while ((entry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                    jos.putNextEntry(new JarEntry(entry.getName()));
                    String name = entry.getName();
                    if (fullPath.equals(name)) {
                        found = true;
                        ByteArrayInputStream i = new ByteArrayInputStream(fileContent.getBytes());
                        int len = 0;
                        byte[] copyBuf = new byte[1024];
                        while (len != -1) {
                            len = i.read(copyBuf, 0, copyBuf.length);
                            if (len <= 0) continue;
                            jos.write(copyBuf, 0, len);
                        }
                        i.close();
                    } else {
                        int len = 0;
                        byte[] copyBuf = new byte[1024];
                        while (len != -1) {
                            len = ((JarInputStream)jis).read(copyBuf, 0, copyBuf.length);
                            if (len <= 0) continue;
                            jos.write(copyBuf, 0, len);
                        }
                    }
                    jis.closeEntry();
                    jos.closeEntry();
                }
                if (!found) {
                    jos.putNextEntry(new JarEntry(fullPath));
                    ByteArrayInputStream i = new ByteArrayInputStream(fileContent.getBytes());
                    int len = 0;
                    byte[] copyBuf = new byte[1024];
                    while (len != -1) {
                        len = i.read(copyBuf, 0, copyBuf.length);
                        if (len <= 0) continue;
                        jos.write(copyBuf, 0, len);
                    }
                    i.close();
                    jos.closeEntry();
                }
            }
            item.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream(bais.toByteArray()));
            item.checkin("Updated " + fileName);
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        finally {
            if (jis != null) {
                jis.close();
            }
            jos.close();
        }
    }

    private Collection<String> createWorkflow(String fullPath, String workflowName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(fullPath + "/" + workflowName);
        list.add(this.getFullPath(fullPath, workflowName, "bpr"));
        list.add(this.getFullPath(fullPath, workflowName, "bpel"));
        list.add(this.getFullPath(fullPath, workflowName, "wsdl"));
        list.add(this.getFullPath(fullPath, workflowName, "pdd"));
        list.add(this.getFullPath(fullPath, workflowName, "xml"));
        return list;
    }
}

