/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.SortDir;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.GroupingStore;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.SortState;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.ToolbarItem;
import com.gwtext.client.widgets.ToolbarSeparator;
import com.gwtext.client.widgets.ToolbarTextItem;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.event.GridRowListener;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionViewer
extends Composite {
    private static Images images = (Images)GWT.create(Images.class);
    private Constants constants = (Constants)GWT.create(Constants.class);
    private VerticalPanel layout = new VerticalPanel();
    private GridPanel grid;

    public PermissionViewer() {
        this.layout.setHeight("100%");
        this.layout.setWidth("100%");
        this.layout.add(this.howToTurnOn());
        this.refresh();
        this.initWidget((Widget)this.layout);
    }

    private Widget howToTurnOn() {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new HTML("<small><i>" + this.constants.TipAuthEnable() + "</i></small>"));
        InfoPopup pop = new InfoPopup(this.constants.EnablingAuthorization(), this.constants.EnablingAuthPopupTip());
        hp.add((Widget)pop);
        return hp;
    }

    private void refresh() {
        LoadingPopup.showMessage((String)this.constants.LoadingUserPermissions());
        RepositoryServiceFactory.getService().listUserPermissions((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showUsers(Map<String, List<String>> users) {
        Object[][] data = new Object[users.size()][4];
        int row = 0;
        for (Map.Entry<String, List<String>> userRow : users.entrySet()) {
            data[row][0] = userRow.getKey();
            List<String> permTypes = userRow.getValue();
            data[row][1] = this.isAdmin(permTypes);
            data[row][2] = this.isPackage(permTypes);
            data[row][3] = this.isCategory(permTypes);
            ++row;
        }
        MemoryProxy proxy = new MemoryProxy(data);
        RecordDef recordDef = new RecordDef(new FieldDef[]{new StringFieldDef("userName"), new StringFieldDef("isAdmin"), new StringFieldDef("isPackage"), new StringFieldDef("isCategory")});
        ArrayReader reader = new ArrayReader(recordDef);
        GroupingStore store = new GroupingStore();
        store.setReader((Reader)reader);
        store.setDataProxy((DataProxy)proxy);
        store.setGroupField("isAdmin");
        store.setSortInfo(new SortState("userName", SortDir.ASC));
        store.load();
        ColumnModel cm = new ColumnModel((BaseColumnConfig[])new ColumnConfig[]{new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */});
        this.grid = new GridPanel();
        this.grid.setColumnModel(cm);
        this.grid.setStore((Store)store);
        this.grid.setWidth(550);
        this.grid.setHeight(600);
        Toolbar tb = new Toolbar();
        this.grid.setTopToolbar(tb);
        tb.addItem((ToolbarItem)new ToolbarTextItem(this.constants.CurrentlyConfiguredUsers()));
        tb.addItem((ToolbarItem)new ToolbarSeparator());
        this.layout.add((Widget)this.grid);
        ToolbarButton reload = new ToolbarButton(this.constants.Reload1());
        reload.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(reload);
        this.grid.addGridRowListener((GridRowListener)new /* Unavailable Anonymous Inner Class!! */);
        ToolbarButton create = new ToolbarButton(this.constants.CreateNewUserMapping());
        create.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(create);
        ToolbarButton delete = new ToolbarButton(this.constants.DeleteSelectedUser());
        delete.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(delete);
    }

    private void showEditor(String userName) {
        LoadingPopup.showMessage((String)this.constants.LoadingUsersPermissions());
        RepositoryServiceFactory.getService().retrieveUserPermissions(userName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget doPermsPanel(Map<String, List<String>> perms, Panel vp) {
        vp.clear();
        for (Map.Entry<String, List<String>> perm : perms.entrySet()) {
            if (perm.getKey().equals("admin")) {
                HorizontalPanel h = new HorizontalPanel();
                h.add((Widget)new HTML("<b>" + this.constants.ThisUserIsAnAdministrator() + "</b>"));
                Button del = new Button(this.constants.RemoveAdminRights());
                del.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                h.add((Widget)del);
                vp.add((Widget)h);
                continue;
            }
            String permType = perm.getKey();
            List<String> permList = perm.getValue();
            Grid g = new Grid(permList.size() + 1, 3);
            g.setWidget(0, 0, (Widget)new HTML("<b>[" + permType + "] for:</b>"));
            for (int i = 0; i < permList.size(); ++i) {
                String p = permList.get(i);
                ImageButton del = new ImageButton(images.deleteItemSmall(), this.constants.RemovePermission(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                g.setWidget(i + 1, 1, (Widget)new SmallLabel(p));
                g.setWidget(i + 1, 2, (Widget)del);
            }
            vp.add((Widget)g);
        }
        ImageButton newPermission = new ImageButton(images.newItem(), this.constants.AddANewPermission(), this.createClickHandlerForNewPersmissionImageButton(perms, vp));
        vp.add((Widget)newPermission);
        return vp;
    }

    private ClickHandler createClickHandlerForNewPersmissionImageButton(Map<String, List<String>> perms, Panel vp) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Object isCategory(List<String> permTypes) {
        for (String s : permTypes) {
            if (!s.startsWith("analyst")) continue;
            return this.constants.Yes();
        }
        return "";
    }

    private String isPackage(List<String> permTypes) {
        for (String s : permTypes) {
            if (!s.startsWith("package")) continue;
            return this.constants.Yes();
        }
        return "";
    }

    private String isAdmin(List<String> permTypes) {
        if (permTypes.contains("admin")) {
            return this.constants.Yes();
        }
        return "";
    }

    static /* synthetic */ GridPanel access$000(PermissionViewer x0) {
        return x0.grid;
    }

    static /* synthetic */ VerticalPanel access$100(PermissionViewer x0) {
        return x0.layout;
    }

    static /* synthetic */ void access$200(PermissionViewer x0, Map x1) {
        x0.showUsers(x1);
    }

    static /* synthetic */ Constants access$300(PermissionViewer x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$400(PermissionViewer x0) {
        x0.refresh();
    }

    static /* synthetic */ void access$500(PermissionViewer x0, String x1) {
        x0.showEditor(x1);
    }

    static /* synthetic */ Images access$600() {
        return images;
    }

    static /* synthetic */ Widget access$700(PermissionViewer x0, Map x1, Panel x2) {
        return x0.doPermsPanel(x1, x2);
    }
}

