/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.i18n.client.DateTimeFormat;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.decisiontable.widget.VerticalDecisionTableWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableCellValueFactory {
    private static final DateTimeFormat DATE_FORMAT = DateTimeFormat.getFormat((String)"dd-MMM-yyyy");
    private GuidedDecisionTable model;
    private SuggestionCompletionEngine sce;

    public DecisionTableCellValueFactory(VerticalDecisionTableWidget dtable) {
        if (dtable == null) {
            throw new IllegalArgumentException("dtable cannot be null");
        }
        this.model = dtable.getModel();
        this.sce = dtable.getSCE();
    }

    public CellValue<? extends Comparable<?>> getCellValue(DTColumnConfig column, int iRow, int iCol, String initialValue) {
        DATA_TYPES dataType = this.getDataType(column);
        CellValue cell = dataType.getNewCellValue(iRow, iCol, initialValue);
        return cell;
    }

    public String serialiseValue(DTColumnConfig column, CellValue<?> cv) {
        DATA_TYPES dataType = this.getDataType(column);
        return dataType.serialiseValue(cv);
    }

    private DATA_TYPES getDataType(DTColumnConfig column) {
        DATA_TYPES dataType = DATA_TYPES.STRING;
        if (column instanceof RowNumberCol) {
            dataType = DATA_TYPES.ROW_NUMBER;
        } else if (column instanceof AttributeCol) {
            AttributeCol attrCol = (AttributeCol)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                dataType = attrCol.isUseRowNumber() ? DATA_TYPES.ROW_NUMBER : DATA_TYPES.NUMERIC;
            } else if (attrName.equals("enabled")) {
                dataType = DATA_TYPES.BOOLEAN;
            } else if (attrName.equals("no-loop")) {
                dataType = DATA_TYPES.BOOLEAN;
            } else if (attrName.equals("duration")) {
                dataType = DATA_TYPES.NUMERIC;
            } else if (attrName.equals("auto-focus")) {
                dataType = DATA_TYPES.BOOLEAN;
            } else if (attrName.equals("lock-on-active")) {
                dataType = DATA_TYPES.BOOLEAN;
            } else if (attrName.equals("date-effective")) {
                dataType = DATA_TYPES.DATE;
            } else if (attrName.equals("date-expires")) {
                dataType = DATA_TYPES.DATE;
            } else if (attrName.equals("dialect")) {
                dataType = DATA_TYPES.DIALECT;
            }
        } else if (column instanceof ConditionCol) {
            dataType = this.makeNewCellDataType(column);
        } else if (column instanceof ActionSetFieldCol) {
            dataType = this.makeNewCellDataType(column);
        } else if (column instanceof ActionInsertFactCol) {
            dataType = this.makeNewCellDataType(column);
        }
        return dataType;
    }

    private DATA_TYPES makeNewCellDataType(DTColumnConfig col) {
        DATA_TYPES dataType = DATA_TYPES.STRING;
        String[] vals = this.model.getValueList(col, this.sce);
        if (vals.length == 0) {
            if (this.model.isNumeric(col, this.sce)) {
                dataType = DATA_TYPES.NUMERIC;
            } else if (this.model.isBoolean(col, this.sce)) {
                dataType = DATA_TYPES.BOOLEAN;
            } else if (this.model.isDate(col, this.sce)) {
                dataType = DATA_TYPES.DATE;
            }
        }
        return dataType;
    }

    static /* synthetic */ DateTimeFormat access$100() {
        return DATE_FORMAT;
    }
}

