/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.factconstraints.client.customform.CustomFormConfiguration;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;

public class CustomFormPopUp
extends FormStylePopup {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private final CustomFormConfiguration configuration;
    private final Button okButton;
    private final Button cancelButton;
    private Frame externalFrame;

    public CustomFormPopUp(ImageResource image, String title, CustomFormConfiguration configuration) {
        super(image, title);
        this.configuration = configuration;
        this.externalFrame = new Frame();
        this.externalFrame.setWidth(configuration.getCustomFormWidth() + "px");
        this.externalFrame.setHeight(configuration.getCustomFormHeight() + "px");
        VerticalPanel vp = new VerticalPanel();
        vp.setWidth("100%");
        vp.setHeight("100%");
        vp.add((Widget)this.externalFrame);
        this.okButton = new Button(this.constants.OK());
        this.cancelButton = new Button(this.constants.Cancel(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.setWidth("100%");
        hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        hp.add((Widget)this.okButton);
        hp.add((Widget)this.cancelButton);
        vp.add((Widget)hp);
        this.addRow((Widget)vp);
    }

    public void addOkButtonHandler(ClickHandler handler) {
        this.okButton.addClickHandler(handler);
    }

    public void addCancelButtonHandler(ClickHandler handler) {
        this.cancelButton.addClickHandler(handler);
    }

    public void show(String selectedId, String selectedValue) {
        String url = this.configuration.getCustomFormURL();
        if (url == null || url.trim().equals("")) {
            return;
        }
        String parameters = "cf_id=" + selectedId + "&cf_value=" + selectedValue + "&factType=" + this.configuration.getFactType() + "&fieldName=" + this.configuration.getFieldName();
        url = url + (url.contains("?") ? "&" : "?") + parameters;
        this.externalFrame.setUrl(url);
        this.show();
    }

    private Element getExternalFrameElement(String id) {
        IFrameElement iframe = IFrameElement.as((Element)this.externalFrame.getElement());
        return iframe.getContentDocument().getElementById(id);
    }

    public String getFormId() {
        return this.getExternalFrameElement("cf_id").getPropertyString("value");
    }

    public String getFormValue() {
        return this.getExternalFrameElement("cf_value").getPropertyString("value");
    }
}

