/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.AnalysisReportLine;
import org.drools.guvnor.client.rpc.Cause;
import org.drools.guvnor.client.rulelist.OpenItemCommand;

class VerifierMessageLinesItem
extends TreeItem {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private Images images = (Images)GWT.create(Images.class);
    private OpenItemCommand edit;

    public VerifierMessageLinesItem(String topicHtml, AnalysisReportLine[] lines, OpenItemCommand edit) {
        this.edit = edit;
        this.setStyleName("analysis-Report");
        this.setHTML(topicHtml);
        for (AnalysisReportLine line : lines) {
            TreeItem report = new TreeItem((Widget)new HTML(line.description));
            if (line.reason != null) {
                report.addItem(new TreeItem((Widget)new HTML("<b>" + this.constants.Reason() + ":</b>&nbsp;" + line.reason)));
            }
            TreeItem impactedRules = this.doImpactedRules(line);
            report.addItem(impactedRules);
            if (line.causes.length > 0) {
                TreeItem causes = this.doCauses(new HTML("<b>" + this.constants.Causes() + ":</b>"), line.causes);
                report.addItem(causes);
                causes.setState(true);
            }
            this.addItem(report);
        }
        this.setState(true);
    }

    private TreeItem doImpactedRules(AnalysisReportLine line) {
        TreeItem impactedRules = new TreeItem((Widget)new HTML("<b>" + this.constants.ImpactedRules() + ":</b>&nbsp;"));
        for (String ruleAssetGuid : line.impactedRules.keySet()) {
            HTML rule = new HTML(Format.format((String)"<img src='{0}'/>", (String)new Image(this.images.ruleAsset()).getUrl()) + (String)line.impactedRules.get(ruleAssetGuid));
            rule.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            impactedRules.addItem((Widget)rule);
        }
        return impactedRules;
    }

    private TreeItem doCauses(HTML title, Cause[] causes) {
        TreeItem treeItem = new TreeItem((Widget)title);
        for (Cause cause : causes) {
            treeItem.addItem(this.doCauses(new HTML(cause.getCause()), cause.getCauses()));
        }
        return treeItem;
    }

    static /* synthetic */ OpenItemCommand access$000(VerifierMessageLinesItem x0) {
        return x0.edit;
    }
}

